# CCG CARD Digital Signature - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG CARD Digital Signature**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-signature-definitions.md) 
*  [Mappings](StructureDefinition-ccg-signature-mappings.md) 
*  [Examples](StructureDefinition-ccg-signature-examples.md) 
*  [XML](StructureDefinition-ccg-signature.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-signature.profile.json.md) 
*  [TTL](StructureDefinition-ccg-signature.profile.ttl.md) 

## Resource Profile: CCG CARD Digital Signature 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-signature | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:CCG_Signature |

 
This is a profile on the FHIR Provenance resource to align with CCG requirements for signature 

**Usages:**

* Examples for this Profile: [Provenance/example-ccg-CARD-signature](Provenance-example-ccg-CARD-signature.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-signature)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

**Summary**

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Provenance](http://hl7.org/fhir/R4/provenance.html) 

**Summary**

 

Other representations of profile: [CSV](StructureDefinition-ccg-signature.csv), [Excel](StructureDefinition-ccg-signature.xlsx), [Schematron](StructureDefinition-ccg-signature.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-stopsrv-ad.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-signature-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

