# CCG Data-In Bundle IPS Composition Resource - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG Data-In Bundle IPS Composition Resource**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-di-ips-composition-definitions.md) 
*  [Mappings](StructureDefinition-ccg-di-ips-composition-mappings.md) 
*  [XML](StructureDefinition-ccg-di-ips-composition.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-di-ips-composition.profile.json.md) 
*  [TTL](StructureDefinition-ccg-di-ips-composition.profile.ttl.md) 

## Resource Profile: CCG Data-In Bundle IPS Composition Resource 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-ips-composition | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:CCG_Data_In_IPS_Composition |

 
IPS Composition Resource Profiled for use with CCG 

**Usages:**

* Use this Profile: [CCG IPS Bundle](StructureDefinition-ccg-di-ips-bundle.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-di-ips-composition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CompositionUvIps](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Composition-uv-ips.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CompositionUvIps](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Composition-uv-ips.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 3 elements

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CompositionUvIps](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Composition-uv-ips.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CompositionUvIps](http://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Composition-uv-ips.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 3 elements

 

Other representations of profile: [CSV](StructureDefinition-ccg-di-ips-composition.csv), [Excel](StructureDefinition-ccg-di-ips-composition.xlsx), [Schematron](StructureDefinition-ccg-di-ips-composition.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-data-in-ips-careplan.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-di-ips-composition-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

