# CCG CARD type - Stop Activity (Service Order) - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG CARD type - Stop Activity (Service Order)**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-card-stopsrv-definitions.md) 
*  [Mappings](StructureDefinition-ccg-card-stopsrv-mappings.md) 
*  [Examples](StructureDefinition-ccg-card-stopsrv-examples.md) 
*  [XML](StructureDefinition-ccg-card-stopsrv.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-card-stopsrv.profile.json.md) 
*  [TTL](StructureDefinition-ccg-card-stopsrv.profile.ttl.md) 

## Resource Profile: CCG CARD type - Stop Activity (Service Order) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-stopsrv | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:CCG_Stop_Activity_Service_Order |

 
The role of this type of CCG CARD is to create a Task that, upon being processed, will “stop” a patient's presently active ServiceRequest (i.e. set status to revoked). 

**Usages:**

* Examples for this Profile: [ExampleCARDstopsrv](PlanDefinition-card-example-stopsrv.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-card-stopsrv)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Activity Definition for the Stop Activity (Service Order) CARD(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-stopsrv-ad)](StructureDefinition-ccg-card-stopsrv-ad.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md) 

**Summary**

**Structures**

This structure refers to these other structures:

* [Activity Definition for the Stop Activity (Service Order) CARD(https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-stopsrv-ad)](StructureDefinition-ccg-card-stopsrv-ad.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of PlanDefinition.action.definition[x]

 

Other representations of profile: [CSV](StructureDefinition-ccg-card-stopsrv.csv), [Excel](StructureDefinition-ccg-card-stopsrv.xlsx), [Schematron](StructureDefinition-ccg-card-stopsrv.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-card-stoprx.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-card-stopsrv-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

