# AD Stop Task (Service Order) - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AD Stop Task (Service Order)**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Narrative Content](#) 
*  [XML](ActivityDefinition-activity-example-stopservice-ad.xml.md) 
*  [JSON](ActivityDefinition-activity-example-stopservice-ad.json.md) 
*  [TTL](ActivityDefinition-activity-example-stopservice-ad.ttl.md) 

## ActivityDefinition: AD Stop Task (Service Order) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://example.org/fhir/uv/cpg/ActivityDefinition/activity-example-stopservice-ad | *Version*:1.0.1-current |
| Active as of 2024-11-26 | *Computable Name*:ActivityExampleStopServiceAD |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.48.11.99 | |

 
IHE CCG example for Stop Service Order ActivityDefinition (based on HL7 CPG example) 

* **Code:**: **Id:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: activity-example-stopservice-ad
* **Code:**: **Version:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: 1.0.1-current
* **Code:**: ****
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: urn:oid:2.16.840.1.113883.4.642.40.48.11.99
* **Code:**: **Experimental:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: true
* **Code:**: **Date (date last changed):**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: 2024-11-26 16:34:39+0000
* **Code:**: **Publisher (steward):**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: IHE QRPH Technical Committee
* **Code:**: **Description:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: IHE CCG example for Stop Service Order ActivityDefinition (based on HL7 CPG example)
* **Code:**: **Jurisdiction:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: 001
* **Code:**: **Topic:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: stopsrv
* **Code:**: **Kind:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: Task
* **Code:**: **Profile:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-stoptask
* **Code:**: **Intent:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: proposal
* **Code:**: **doNotPerform:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: false
* **Code:**: **Dynamic Values:**
  * **system:**[http://hl7.org/fhir/uv/cpg/CodeSystem/cpg-activity-type-cs](http://hl7.org/fhir/uv/cpg/STU2/CodeSystem-cpg-activity-type-cs.html)**code:**stop-activity**display:**Stop (discontinue) an activity in progress: * input.type: *(code)*

* input.value: *(Service Request)*



| | | |
| :--- | :--- | :--- |
|  [<prev](ActivityDefinition-activity-example-stopmedication-ad.ttl.md) | [top](#top) |  [next>](ActivityDefinition-activity-example-stopservice-ad-testing.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

