# Table of Contents - Computable Care Guidelines v1.0.1-current

* **Table of Contents**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

## Table of Contents

| |
| :--- |
| [0 Table of Contents](toc.md) |
| [1 Computable Care Guidelines (CCG) Home](index.md) |
| [2 Business Description](CCG_v1_over.md) |
| [3 Actors](CCG_v1_actor.md) |
| [4 2:3.61 Search for Guidelines [QRPH-61]](CCG_v2_x1.md) |
| [5 2:3.62 Retrieve Guideline [QRPH-62]](CCG_v2_x2.md) |
| [6 2:3.63 Publish Guideline [QRPH-63]](CCG_v2_x3.md) |
| [7 2:3.64 Apply Guideline [QRPH-64]](CCG_v2_x4.md) |
| [8 Content Specifications](CCG_v3_launch.md) |
| [9 Jurisdictional Contextualizations](CCG_v4.md) |
| [10 Test Plan](testplan.md) |
| [11 Changes to Other IHE Specifications](other.md) |
| [12 Download and Analysis](download.md) |
| [13 Significant Changes and Issues](issues.md) |
| [14 Artifacts Summary](artifacts.md) |
| [14.1 Guideline Engine](CapabilityStatement-IHE.CCG.GuidelineEngine.md) |
| [14.2 Guideline Performer](CapabilityStatement-IHE.CCG.GuidelinePerformer.md) |
| [14.3 Base CARD PlanDefinition](StructureDefinition-ccg-card-pd-base.md) |
| [14.4 Activity Definition for the Administer Medication CARD](StructureDefinition-ccg-card-adminrx-ad.md) |
| [14.5 Activity Definition for the Collect Information CARD](StructureDefinition-ccg-card-collect-ad.md) |
| [14.6 Activity Definition for the Dispense Medication CARD](StructureDefinition-ccg-card-disprx-ad.md) |
| [14.7 Activity Definition for the Order Medication CARD](StructureDefinition-ccg-card-orderrx-ad.md) |
| [14.8 Activity Definition for the Propose a Diagnosis CARD](StructureDefinition-ccg-card-proposedx-ad.md) |
| [14.9 Activity Definition for the Provide Information CARD](StructureDefinition-ccg-card-provide-ad.md) |
| [14.10 Activity Definition for the Request a Service (Lab Order) CARD](StructureDefinition-ccg-card-reqlabs-ad.md) |
| [14.11 Activity Definition for the Request a Service (Procedure Order) CARD](StructureDefinition-ccg-card-reqprocserv-ad.md) |
| [14.12 Activity Definition for the Request a Service (Radiology Order) CARD](StructureDefinition-ccg-card-reqradserv-ad.md) |
| [14.13 Activity Definition for the Request a Service (Referral) CARD](StructureDefinition-ccg-card-reqrefserv-ad.md) |
| [14.14 Activity Definition for the Request Immunization CARD](StructureDefinition-ccg-card-reqvx-ad.md) |
| [14.15 Activity Definition for the Stop Activity (Medication Order) CARD](StructureDefinition-ccg-card-stoprx-ad.md) |
| [14.16 Activity Definition for the Stop Activity (Service Order) CARD](StructureDefinition-ccg-card-stopsrv-ad.md) |
| [14.17 CCG CARD Digital Signature](StructureDefinition-ccg-signature.md) |
| [14.18 CCG CARD Folder PlanDefinition](StructureDefinition-ccg-card-folder.md) |
| [14.19 CCG CARD type - Administer Medication](StructureDefinition-ccg-card-adminrx.md) |
| [14.20 CCG CARD type - Collect Information](StructureDefinition-ccg-card-collect.md) |
| [14.21 CCG CARD type - Dispense Medication](StructureDefinition-ccg-card-disprx.md) |
| [14.22 CCG CARD type - Order Medication](StructureDefinition-ccg-card-orderrx.md) |
| [14.23 CCG CARD type - Propose a Diagnosis](StructureDefinition-ccg-card-proposedx.md) |
| [14.24 CCG CARD type - Provide Information](StructureDefinition-ccg-card-provide.md) |
| [14.25 CCG CARD type - Request a Service (Lab Order)](StructureDefinition-ccg-card-reqserv-labs.md) |
| [14.26 CCG CARD type - Request a Service (Procedure Order)](StructureDefinition-ccg-card-reqprocserv.md) |
| [14.27 CCG CARD type - Request a Service (Radiology Order)](StructureDefinition-ccg-card-reqradserv.md) |
| [14.28 CCG CARD type - Request a Service (Referral)](StructureDefinition-ccg-card-reqrefserv.md) |
| [14.29 CCG CARD type - Request Immunization](StructureDefinition-ccg-card-reqvx.md) |
| [14.30 CCG CARD type - Stop Activity (Medication Order)](StructureDefinition-ccg-card-stoprx.md) |
| [14.31 CCG CARD type - Stop Activity (Service Order)](StructureDefinition-ccg-card-stopsrv.md) |
| [14.32 CCG Data In Bundle](StructureDefinition-ccg-di-bundle.md) |
| [14.33 CCG Data-In Bundle Encounter](StructureDefinition-ccg-di-encounter.md) |
| [14.34 CCG Data-In Bundle IPS CarePlan Specific Resource](StructureDefinition-ccg-data-in-ips-careplan.md) |
| [14.35 CCG Data-In Bundle IPS Composition Resource](StructureDefinition-ccg-di-ips-composition.md) |
| [14.36 CCG Data-In Bundle Location](StructureDefinition-ccg-di-location.md) |
| [14.37 CCG Data-In Bundle Organization](StructureDefinition-ccg-di-organization.md) |
| [14.38 CCG Data-In Bundle Practitioner](StructureDefinition-ccg-di-practitioner.md) |
| [14.39 CCG Data-In Bundle PractitionerRole](StructureDefinition-ccg-di-practitionerrole.md) |
| [14.40 CCG Deployment Package (IG)](StructureDefinition-ccg-deployment.md) |
| [14.41 CCG IPS Bundle](StructureDefinition-ccg-di-ips-bundle.md) |
| [14.42 CCG Library for CARDs](StructureDefinition-ccg-card-library.md) |
| [14.43 CCG Patient Plans (patient-specific) PlanDefinition](StructureDefinition-ccg-patient-plans.md) |
| [14.44 AllowedSignature signatureFormat](ValueSet-ccg-signature-sigformat.md) |
| [14.45 AllowedSignature targetFormat](ValueSet-ccg-signature-target.md) |
| [14.46 ValueSet of all Current CCG Card Types](ValueSet-ccg-card-type.md) |
| [14.47 Code System for All CCG Card Types](CodeSystem-ccg-card-type-cs.md) |
| [14.48 AD Administer Meds](ActivityDefinition-activity-example-administermedication-ad.md) |
| [14.49 AD Collect info](ActivityDefinition-activity-example-collectinformation-ad.md) |
| [14.50 AD Dispense Meds](ActivityDefinition-activity-example-dispensemedication-ad.md) |
| [14.51 AD Order Meds](ActivityDefinition-activity-example-ordermedication-ad.md) |
| [14.52 AD Propose Diagnosis](ActivityDefinition-activity-example-proposediagnosis-ad.md) |
| [14.53 AD Provide Information](ActivityDefinition-activity-example-sendmessage-ad.md) |
| [14.54 AD Recommend Immunization](ActivityDefinition-activity-example-recommendimmunization-ad.md) |
| [14.55 AD Service Request (Lab Order)](ActivityDefinition-activity-example-orderservice-lab-ad.md) |
| [14.56 AD Service Request (Procedure Order)](ActivityDefinition-activity-example-orderservice-proc-ad.md) |
| [14.57 AD Service Request (Radiology Order)](ActivityDefinition-activity-example-orderservice-rad-ad.md) |
| [14.58 AD Service Request (Referral Order)](ActivityDefinition-activity-example-orderservice-ref-ad.md) |
| [14.59 AD Stop Task (Medication Order)](ActivityDefinition-activity-example-stopmedication-ad.md) |
| [14.60 AD Stop Task (Service Order)](ActivityDefinition-activity-example-stopservice-ad.md) |
| [14.61 CARD Administer Medication](PlanDefinition-card-example-adminrx.md) |
| [14.62 CARD Collect Information](PlanDefinition-card-example-collect.md) |
| [14.63 CARD Digital Signature example](Provenance-example-ccg-CARD-signature.md) |
| [14.64 CARD Dispense Medication](PlanDefinition-card-example-disprx.md) |
| [14.65 CARD Order Medication](PlanDefinition-card-example-orderrx.md) |
| [14.66 CARD Propose Diagnosis](PlanDefinition-card-example-propdx.md) |
| [14.67 CARD Provide Information](PlanDefinition-card-example-provide.md) |
| [14.68 CARD Recommend Immunization](PlanDefinition-card-example-reqvx.md) |
| [14.69 CARD Recommend Lab Order](PlanDefinition-card-example-reqlab.md) |
| [14.70 CARD Recommend Procedure Order](PlanDefinition-card-example-reqproc.md) |
| [14.71 CARD Recommend Radiology Order](PlanDefinition-card-example-reqrad.md) |
| [14.72 CARD Recommend Referral Order](PlanDefinition-card-example-reqref.md) |
| [14.73 CARD Stop Medication Order](PlanDefinition-card-example-stoprx.md) |
| [14.74 CARD Stop Service Order](PlanDefinition-card-example-stopsrv.md) |
| [14.75 CCG Folder 1](PlanDefinition-ccg-folder-Diabetes.md) |
| [14.76 CCG Folder 2](PlanDefinition-ccg-folder-Hypertension.md) |
| [14.77 Data-in Care Plan](CarePlan-CCG-careplan-example.md) |
| [14.78 Data-in Encounter](Encounter-Encounter-1234567.md) |
| [14.79 Data-in Location](Location-Location-12.md) |
| [14.80 Data-in Organization](Organization-Organization-14.md) |
| [14.81 Data-in Patient](Patient-ZKT9319.md) |
| [14.82 Data-in PlanDefinition for Patient CCGs](PlanDefinition-CCG-patient-plans-example.md) |
| [14.83 Data-in Practitioner](Practitioner-Practitioner-123.md) |
| [14.84 Data-in PractitionerRole](PractitionerRole-PractitionerRole-124.md) |

| | | |
| :--- | :--- | :--- |
|  <prev | [top](#top) |  [next>](index.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

