# Computable Care Guidelines (CCG) Home - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* **Computable Care Guidelines (CCG) Home**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

## Computable Care Guidelines (CCG) Home

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/ImplementationGuide/ihe.qrph.ccg | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:IHE_QRPH_CCG |

* [Organization of This Guide](#organization-of-this-guide)
* [Conformance Expectations](#conformance-expectations)

The IHE Computable Care Guidelines (CCG) Profile specifies a normative grammar and a normative transaction processing model that allows evidence-based care recommendations to be expressed in a way that a digital health solution can ingest and operationalize. This is an implementable and conformance-testable specification. It is targeted to regulated healthcare markets where the support for multiple conditions is an important requirement. The CCG Profile supports jurisdictions that want to leverage digital health to systemically improve the adoption of guideline-adherent best practices across an entire care delivery network.

| |
| :--- |
| [Significant Changes; Open and Closed Issues](issues.md) |

### Organization of This Guide

This guide is organized into the following sections:

1. Volume 1:
1. [Business Description](CCG_v1_over.md)
1. [Actors](CCG_v1_actor.md)

1. Volume 2: Transaction Detail
1. [Search for Guidelines [QRPH-61]](CCG_v2_x1.md)
1. [Retrieve Guideline [QRPH-62]](CCG_v2_x2.md)
1. [Publish Guidelines [QRPH-63]](CCG_v2_x3.md)
1. [Apply Guidelines [QRPH-64]](CCG_v2_x4.md)

1. Volume 3: Metadata and Content
1. [Content Specifications](CCG_v3_launch.md)

1. Volume 4: National Extensions
1. [Jurisdictional Contextualizations](CCG_v4.md)

1. Other
1. [Changes to Other IHE Specifications](other.md)
1. [Download and Analysis](download.md)
1. [Test Plan](testplan.md)

See also the [Table of Contents](toc.md) and the index of [Artifacts](artifacts.md) defined as part of this implementation guide.

### Conformance Expectations

IHE uses the normative words: “REQUIRED”, “REQUIRED NOT”, “SHALL”, “SHALL NOT”, “SHOULD”, “SHOULD NOT”, “RECOMMENDED”, “MAY”, and “OPTIONAL” according to [standards conventions](https://profiles.ihe.net/GeneralIntro/ch-E.html).

#### Must Support

The use of `mustSupport` in StructureDefinition profiles equivalent to the IHE use of **R2** as defined in [Appendix Z](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.10-profiling-conventions-for-constraints-on-fhir).

mustSupport of true - only has a meaning on items that are minimal cardinality of zero (0), and applies only to the source actor populating the data. The source actor shall populate the elements marked with MustSupport, if the concept is supported by the actor, a value exists, and security and consent rules permit. The consuming actors should handle these elements being populated or being absent/empty. Note that sometimes mustSupport will appear on elements with a minimal cardinality greater than zero (0), this is due to inheritance from a less constrained profile.

| | | |
| :--- | :--- | :--- |
|  [<prev](toc.md) | [top](#top) |  [next>](CCG_v1_over.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

