# Download and Analysis - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* **Download and Analysis**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

## Download and Analysis

You can also download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), or [ttl](definitions.ttl.zip)
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on the [IHE CCG Profile GitHub](https://github.com/IHE/QRPH.CCG)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B} systems. Packages for both [R4 (ihe.qrph.ccg.r4)](package.r4.tgz) and [R4B (ihe.qrph.ccg.r4b)](package.r4b.tgz) are available.

#### Dependency Table








#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.0.0/CodeSystem-v2-0131.html): [Patient/ZKT9319](Patient-ZKT9319.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [ActivityExampleOrderMedicationAD](ActivityDefinition-activity-example-ordermedication-ad.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [Provenance/example-ccg-CARD-signature](Provenance-example-ccg-CARD-signature.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [CCG_Data_In_IPS_Composition](StructureDefinition-ccg-di-ips-composition.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [ActivityExampleOrderMedicationAD](ActivityDefinition-activity-example-ordermedication-ad.md), [ActivityExampleRecommendImmunizationAD](ActivityDefinition-activity-example-recommendimmunization-ad.md), [Encounter/Encounter-1234567](Encounter-Encounter-1234567.md) and [PractitionerRole/PractitionerRole-124](PractitionerRole-PractitionerRole-124.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [DoseAndRateType](http://terminology.hl7.org/6.5.0/CodeSystem-dose-rate-type.html): [ActivityExampleOrderMedicationAD](ActivityDefinition-activity-example-ordermedication-ad.md)
* [Location type](http://terminology.hl7.org/6.5.0/CodeSystem-location-physical-type.html): [Example Location](Location-Location-12.md)
* [PlanDefinitionType](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html): [CCG_Administer_Medication](StructureDefinition-ccg-card-adminrx.md), [CCG_CARD_Folder](StructureDefinition-ccg-card-folder.md)...Show 29 more,[CCG_CARD_PlanDefinition](StructureDefinition-ccg-card-pd-base.md),[CCG_Collect_Information](StructureDefinition-ccg-card-collect.md),[CCG_Dispense_Medication](StructureDefinition-ccg-card-disprx.md),[CCG_Order_Medication](StructureDefinition-ccg-card-orderrx.md),[CCG_Patient_Plans](StructureDefinition-ccg-patient-plans.md),[CCG_Propose_Diagnosis](StructureDefinition-ccg-card-proposedx.md),[CCG_Provide_Information](StructureDefinition-ccg-card-provide.md),[CCG_Request_Immunization](StructureDefinition-ccg-card-reqvx.md),[CCG_Request_Service_Lab_Order](StructureDefinition-ccg-card-reqserv-labs.md),[CCG_Request_Service_Procedure](StructureDefinition-ccg-card-reqprocserv.md),[CCG_Request_Service_Radiology](StructureDefinition-ccg-card-reqradserv.md),[CCG_Request_Service_Referral](StructureDefinition-ccg-card-reqrefserv.md),[CCG_Stop_Activity_Medication_Order](StructureDefinition-ccg-card-stoprx.md),[CCG_Stop_Activity_Service_Order](StructureDefinition-ccg-card-stopsrv.md),[ExampleCARDadminrx](PlanDefinition-card-example-adminrx.md),[ExampleCARDcollect](PlanDefinition-card-example-collect.md),[ExampleCARDdisprx](PlanDefinition-card-example-disprx.md),[ExampleCARDorderrx](PlanDefinition-card-example-orderrx.md),[ExampleCARDpropdx](PlanDefinition-card-example-propdx.md),[ExampleCARDprovide](PlanDefinition-card-example-provide.md),[ExampleCARDreqlab](PlanDefinition-card-example-reqlab.md),[ExampleCARDreqproc](PlanDefinition-card-example-reqproc.md),[ExampleCARDreqrad](PlanDefinition-card-example-reqrad.md),[ExampleCARDreqref](PlanDefinition-card-example-reqref.md),[ExampleCARDreqvx](PlanDefinition-card-example-reqvx.md),[ExampleCARDstoprx](PlanDefinition-card-example-stoprx.md),[ExampleCARDstopsrv](PlanDefinition-card-example-stopsrv.md),[ExampleCCGFolder1](PlanDefinition-ccg-folder-Hypertension.md)and[PlanDefinition/CCG-patient-plans-example](PlanDefinition-CCG-patient-plans-example.md)
* [ActClass](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActClass.html): [CCG_Data_In_IPS_Composition](StructureDefinition-ccg-di-ips-composition.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Encounter/Encounter-1234567](Encounter-Encounter-1234567.md)
* [MaritalStatus](http://terminology.hl7.org/6.5.0/CodeSystem-v3-MaritalStatus.html): [Patient/ZKT9319](Patient-ZKT9319.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [Encounter/Encounter-1234567](Encounter-Encounter-1234567.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Example Location](Location-Location-12.md)


| | | |
| :--- | :--- | :--- |
|  [<prev](other.md) | [top](#top) |  [next>](issues.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

