# CCG Data-In Bundle Encounter - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG Data-In Bundle Encounter**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-di-encounter-definitions.md) 
*  [Mappings](StructureDefinition-ccg-di-encounter-mappings.md) 
*  [Examples](StructureDefinition-ccg-di-encounter-examples.md) 
*  [XML](StructureDefinition-ccg-di-encounter.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-di-encounter.profile.json.md) 
*  [TTL](StructureDefinition-ccg-di-encounter.profile.ttl.md) 

## Resource Profile: CCG Data-In Bundle Encounter 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-di-encounter | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:CCG_Data_In_Encounter |

 
Identifies the Encounter to which the CCG Apply Guideline transaction is relevant. 

**Usages:**

* Use this Profile: [CCG Data In Bundle](StructureDefinition-ccg-di-bundle.md)
* Examples for this Profile: [Encounter/Encounter-1234567](Encounter-Encounter-1234567.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-di-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGEncounter](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-encounter.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGEncounter](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-encounter.html) 

**Summary**

Mandatory: 1 element(1 nested mandatory element)
 Must-Support: 1 element
 Fixed: 1 element
 Prohibited: 1 element

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CPGEncounter](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-encounter.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGEncounter](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-encounter.html) 

**Summary**

Mandatory: 1 element(1 nested mandatory element)
 Must-Support: 1 element
 Fixed: 1 element
 Prohibited: 1 element

 

Other representations of profile: [CSV](StructureDefinition-ccg-di-encounter.csv), [Excel](StructureDefinition-ccg-di-encounter.xlsx), [Schematron](StructureDefinition-ccg-di-encounter.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-di-bundle.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-di-encounter-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

