# CCG Deployment Package (IG) - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCG Deployment Package (IG)**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-deployment-definitions.md) 
*  [Mappings](StructureDefinition-ccg-deployment-mappings.md) 
*  [XML](StructureDefinition-ccg-deployment.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-deployment.profile.json.md) 
*  [TTL](StructureDefinition-ccg-deployment.profile.ttl.md) 

## Resource Profile: CCG Deployment Package (IG) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-deployment | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:CCG_Deployment_Package |

 
The deployment model is that each unique CCG Folder and its contents will be contained in a FHIR package. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-deployment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGComputableGuideline](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html) 

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGComputableGuideline](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html) 

**Summary**

Mandatory: 4 elements

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CPGComputableGuideline](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html) 

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGComputableGuideline](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html) 

**Summary**

Mandatory: 4 elements

 

Other representations of profile: [CSV](StructureDefinition-ccg-deployment.csv), [Excel](StructureDefinition-ccg-deployment.xlsx), [Schematron](StructureDefinition-ccg-deployment.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-ccg-di-practitionerrole.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-deployment-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

