# Base CARD PlanDefinition - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Base CARD PlanDefinition**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ccg-card-pd-base-definitions.md) 
*  [Mappings](StructureDefinition-ccg-card-pd-base-mappings.md) 
*  [XML](StructureDefinition-ccg-card-pd-base.profile.xml.md) 
*  [JSON](StructureDefinition-ccg-card-pd-base.profile.json.md) 
*  [TTL](StructureDefinition-ccg-card-pd-base.profile.ttl.md) 

## Resource Profile: Base CARD PlanDefinition ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/QRPH/CCG/StructureDefinition/ccg-card-pd-base | *Version*:1.0.1-current |
| Active as of 2025-10-06 | *Computable Name*:CCG_CARD_PlanDefinition |

 
Profile to serve as the basis for all CARD PlanDefinitions based on the CPG Computable PlanDefinition 

**Usages:**

* Derived from this Profile: [CCG CARD type - Administer Medication](StructureDefinition-ccg-card-adminrx.md), [CCG CARD type - Collect Information](StructureDefinition-ccg-card-collect.md), [CCG CARD type - Dispense Medication](StructureDefinition-ccg-card-disprx.md), [CCG CARD type - Order Medication](StructureDefinition-ccg-card-orderrx.md)...Show 9 more,[CCG CARD type - Propose a Diagnosis](StructureDefinition-ccg-card-proposedx.md),[CCG CARD type - Provide Information](StructureDefinition-ccg-card-provide.md),[CCG CARD type - Request a Service (Procedure Order)](StructureDefinition-ccg-card-reqprocserv.md),[CCG CARD type - Request a Service (Radiology Order)](StructureDefinition-ccg-card-reqradserv.md),[CCG CARD type - Request a Service (Referral)](StructureDefinition-ccg-card-reqrefserv.md),[CCG CARD type - Request a Service (Lab Order)](StructureDefinition-ccg-card-reqserv-labs.md),[CCG CARD type - Request Immunization](StructureDefinition-ccg-card-reqvx.md),[CCG CARD type - Stop Activity (Medication Order)](StructureDefinition-ccg-card-stoprx.md)and[CCG CARD type - Stop Activity (Service Order)](StructureDefinition-ccg-card-stopsrv.md)
* Refer to this Profile: [CCG CARD Folder PlanDefinition](StructureDefinition-ccg-card-folder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.qrph.ccg|current/StructureDefinition/ccg-card-pd-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGComputablePlanDefinition](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableplandefinition.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGComputablePlanDefinition](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableplandefinition.html) 

**Summary**

Mandatory: 8 elements
 Fixed: 2 elements
 Prohibited: 1 element

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [CPGComputablePlanDefinition](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableplandefinition.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [CPGComputablePlanDefinition](http://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableplandefinition.html) 

**Summary**

Mandatory: 8 elements
 Fixed: 2 elements
 Prohibited: 1 element

 

Other representations of profile: [CSV](StructureDefinition-ccg-card-pd-base.csv), [Excel](StructureDefinition-ccg-card-pd-base.xlsx), [Schematron](StructureDefinition-ccg-card-pd-base.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](CapabilityStatement-IHE.CCG.GuidelinePerformer.ttl.md) | [top](#top) |  [next>](StructureDefinition-ccg-card-pd-base-definitions.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

