# 2:3.62 Retrieve Guideline [QRPH-62] - Computable Care Guidelines v1.0.1-current

* [**Table of Contents**](toc.md)
* **2:3.62 Retrieve Guideline [QRPH-62]**

Computable Care Guidelines, published by IHE QRPH Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.0.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/QRPH.CCG/](https://github.com/IHE/QRPH.CCG/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/QRPH/CCG/history.html)

## 2:3.62 Retrieve Guideline [QRPH-62]

* [2:3.62.1 Scope](#23621-scope)
* [2:3.62.1 Actor Roles](#23621-actor-roles)
* [2:3.62.3 Referenced Standard(s)](#23623-referenced-standards)
* [2:3.62.4 Messages](#23624-messages)
* [2:3.62.5 Security and Audit Considerations](#23625-security-and-audit-considerations)

### 2:3.62.1 Scope

Transaction Retrieve Guideline [QRPH-62] is used to download and ingest a CCG that has been published to a Guideline Repository. The query parameters denote the specific CCG. The transaction response is the CCG package (FHIR IG) that meets the search criteria. The transaction content and behavior related to this content will depend upon the [Common Content Model](CCG_v1_actor.md#common-content-model) option to which the Guideline Publisher, Guideline Engine and Guideline Repository actors claim conformance.

### 2:3.62.1 Actor Roles

**Table 2:3.62.2-1: Actor Roles**

| | |
| :--- | :--- |
| Guideline Publisher | Optionally, queries for a CCG to be downloaded and ingested |
| Guideline Engine | Queries for a CCG to be downloaded and ingested |
| Guideline Repository | Responds with the CCG package that meets the query criteria |

### 2:3.62.3 Referenced Standard(s)

Transaction Retrieve Guideline [QRPH-62] is based on the following standards:

* HL7 FHIR standard Release 4 [http://hl7.org/fhir/R4/index.html](http://hl7.org/fhir/R4/index.html)
* Draft HL7 CRMI[1](#fn:1) specification [https://build.fhir.org/ig/HL7/crmi-ig/distribution.html#distribution-fhir-package](https://build.fhir.org/ig/HL7/crmi-ig/distribution.html#distribution-fhir-package)
* Node Package Manager version 10.9.1 [https://docs.npmjs.com/cli/v10/commands/npm-install](https://docs.npmjs.com/cli/v10/commands/npm-install)
* CPG Computable Guideline STU2 specification: [https://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html](https://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html)

### 2:3.62.4 Messages

**Figure 2:3.62.4-1 - Retrieve Guideline [QRPH-62] Interaction Diagram**


#### 2:3.62.4.1 Trigger Events - Initiator

A Guideline Publisher may trigger a Retrieve Guideline transaction to download and ingest a specific CCG for subsequent editing. The specific CCG to be retrieved may be based on the results from a prior Search for Guidelines transaction.

A Guideline Engine shall trigger a Retrieve Guideline transaction for each new or updated CCGs to be downloaded and ingested. This may be an automated process that operates on a periodic basis. The CCG to be retrieved may be based on the results from a prior Search for Guidelines transaction.

#### 2:3.62.4.2 Message Semantics - Initiator

The command to retrieve a CCG is submitted by the Guideline Publisher or Guideline Engine to the Guideline Repository using the **npm install** command and grammar.

npm install [<package-spec> …]

#### 2:3.62.4.3 Expected Actions - Initiator

Prior to submitting the transaction, the transaction initiator:

* **SHALL** correctly configure npm to point to the Guideline Repository registry URL;
* **MAY** authenticate to the Guideline Repository.

Based on receipt of the transaction response, the transaction initiator:

* **MAY** execute an **npm audit signatures** command;
* **MAY** create an audit record;
* Processes the response in accordance with its application and user interface logic.

#### 2:3.62.4.4 Trigger Events - Responder

The Guideline Repository responds to inbound Retrieve Guideline transactions as they are received.

#### 2:3.62.4.5 Message Semantics - Responder

The transaction result is a FHIR package (tarball) containing an Implementation Guide adherent to the CPG Computable Guideline STU2 specification: [https://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html](https://hl7.org/fhir/uv/cpg/STU2/StructureDefinition-cpg-computableguideline.html).

#### 2:3.62.4.6 Expected Actions - Responder

Upon receiving a submitted transaction, the transaction responder:

* **MAY** confirm the transaction initiator’s authentication to the Guideline Repository and their authority to execute the submitted transaction;
* **SHALL** return a well-formed FHIR IG package (or exception response) to the transaction initiator.

Based on the returned transaction response, the transaction responder:

* **MAY** create an audit record;
* Executes other processes in accordance with its application logic.

### 2:3.62.5 Security and Audit Considerations

This transaction does **not** convey personal health information (PHI).

FHIR-related security considerations SHOULD be adopted as described in [IHE ITI Appendix Z](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.8-mobile-security-considerations).

**Footnotes**

1. The CRMI specification draft is referenced, but the reference will be updated to the STU2 version upon completion and balloting of this work item within the HL7 working group [↩](#fnref:1)

| | | |
| :--- | :--- | :--- |
|  [<prev](CCG_v2_x1.md) | [top](#top) |  [next>](CCG_v2_x3.md) |

 IG © 2025+ [IHE QRPH Technical Committee](https://www.ihe.net/ihe_domains/quality_research_and_public_health/). Package ihe.qrph.ccg#1.0.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/QRPH.CCG/issues/new/choose)|[Issues](https://github.com/IHE/QRPH.CCG/issues)[Version History](https://profiles.ihe.net/QRPH/CCG/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

