# Artifacts Summary - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [PSCc Content Consumer](CapabilityStatement-IHE.PSCc.Content-Consumer.md) | The PSCc[Content Consumer](volume-1.md#Content-Consumer) |
| [PSCc Content Creator](CapabilityStatement-IHE.pscc.Content-Creator.md) | The PSCc[Content Creator](volume-1.md#Content-Creator) |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [Allergies And Other Adverse Reactions Section](StructureDefinition-IHE.PCC.CDA.AllergiesAndOtherAdverseReactions.Section.md) | The adverse and other adverse reactions section shall contain a narrative description of the substance intolerances and the associated adverse reactions suffered by the patient. It shall include entries for intolerances and adverse reactions as described in the Entry Content Modules.TBD- IF more modeled after CCDA AllergiesAndIntolerancesSection structure |
| [Comments](StructureDefinition-IHE.PCC.Comment.Entry.md) | This entry allows for a comment to be supplied with each entry. For CDA this structure is usually included in the target act using the <entryRelationship> element defined in the CDA Schema, but can also be used in the <component> element when the comment appears within an <organizer>. The example below shows recording a comment for an <entry>, and is used as context for the following sections. For HL7 Version 3 Messages, this relationship is represented with the element <sourceOf>, although the remainder of the typecodes and semantics are unchanged.Any condition or allergy may be the subject of a comment. |
| [Coverage Entry](StructureDefinition-IHE.PCC.CDA.Coverage.Entry.md) | A Coverage Activity groups the policy and authorization acts within a Payers Section to order the payment sources. A Coverage Activity contains one or more Policy Activities, each of which contains zero or more Authorization Activities. The sequenceNumber/@value shows the policy order of preference. The Member Identifier is described in the contained Policy Activity Template 2.16.840.1.113883.10.20.22.4.61.^HL7 C_CDA descriptionPayers shall be recorded as described in CCD: 3.1.2.1.1. ^IHE description |
| [Health Status](StructureDefinition-IHE.Health.Status.Observation.md) | A problem observation may reference a health status observation. This structure is included in the target observation using the <entryRelationship> element defined in the CDA Schema. The health status observation records information about the current health status of the patient. The example below shows the recording the health status, and is used as the context for the following sections. |
| [IHE Active Problems Section](StructureDefinition-IHE.PCC.Active.Problems.Section.md) | The active problem section shall contain a narrative description of the conditions currently being monitored for the patient. It shall include entries for patient conditions as described in the Entry Content Module. |
| [IHE Allergies and Intolerances Concern Entry](StructureDefinition-IHE.Allergies.And.Intolerances.Concern.Entry.md) | TBD |
| [IHE Allergies and Intolerances Entry](StructureDefinition-IHE.Allergies.And.Intolerances.Entry.md) | Allergies and intolerances are special kinds of problems, and so are also recorded in the CDA <observation> element, with classCode='OBS'. They follow the same pattern as the problem entry, with exceptions noted.TBD Still needs to be finished building Troubleshooting for comment needs to be done |
| [IHE Concern Entry](StructureDefinition-IHE.PCC.Concern.Entry.md) | This event (moodCode='EVN') represents an act (<act classCode='ACT') of being concerned about a problem, allergy or other issue. The <effectiveTime> element describes the period of concern. The subject of concern is one or more observations about related problems (see 1.3.6.1.4.1.19376.1.5.3.1.4.5.2) or allergies and intolerances (see 1.3.6.1.4.1.19376.1.5.3.1.4.5.3). Additional references can be provided having additional information related to the concern. The concern entry allows related acts to be grouped. This4415 allows representing the history of a problem as a series of observation over time, for example. |
| [IHE Medical Summary CDA](StructureDefinition-IHE.PCC.MS.CDA.md) | TBD |
| [IHE Payers Section](StructureDefinition-IHE.PCC.CDA.Payers.Section.md) | The Payers section contains data on the patient’s payers, whether a ‘third party’ insurance, self-pay, other payer or guarantor, or some combination. |
| [IHE Probelm Concern Entry](StructureDefinition-IHE.Problem.Concern.Entry.md) | This entry is a specialization of the Concern Entry, wherein the subject of the concern is focused on a problem. |
| [IHE Probelm Reaction Entry](StructureDefinition-IHE.Problem.Reaction.Entry.md) | TBD… |
| [Medical Document](StructureDefinition-IHE.PCC.MD.CDA.md) | This Structure Definition defines the base set of constraints used by almost all medical document profiles described the PCC Technical Framework. |
| [Payers Entry](StructureDefinition-IHE.PCC.CDA.Payers.Entry.md) | The payer entry allows information about the patient's sources of payment to be recorded.TBD if more |
| [Problem Entry](StructureDefinition-IHE.PCC.Problem.Entry.md) | This section makes use of the linking, severity, clinical status and comment content specifications defined elsewhere in the technical framework. In HL7 RIM parlance, observations about a problem, complaint, symptom, finding, diagnosis, or functional limitation of a patient is the event (moodCode='EVN') of observing (<observation classCode='OBS'>) that problem. The <value> of the observation comes from a controlled vocabulary representing such things. The <code> contained within the <observation> describes the method of determination from yet another controlled vocabulary. An example appears below in the figure belowThe basic pattern for reporting a problem uses the CDA <observation> element, setting the classCode='OBS' to represent that this is an observation of a problem, and the moodCode='EVN', to represent that this is an observation that has in fact taken place. The negationInd attribute, if true, specifies that the problem indicated was observed to not have occurred (which is subtly but importantly different from having not been observed).The value of negationInd should not normally be set to true. Instead, to record that there is 'no prior history of chicken pox', one would use a coded value indicated exactly that. However, it is not always possible to record problems in this manner, especially if using a controlled vocabulary that does not supply pre-coordinated negations, or which do not allow the negation to be recorded with post-coordinated coded terminology.TBD for more |
| [Problem Status Observation](StructureDefinition-IHE.Problem.Status.Observation.md) | Any problem or allergy observation may reference a problem status observation. This structure is included in the target observation using the <entryRelationship> element defined in the CDA Schema. The clinical status observation records information about the current status of the problem or allergy, for example, whether it is active, in remission, resolved, et cetera. The example below shows the recording of clinical status of a condition or allergy, and is used as the context for the following sections. |
| [Severity Entry](StructureDefinition-IHE.PCC.Severity.Entry.md) | Any condition or allergy may be the subject of a severity observation. This structure is included in the target act using the <entryRelationship> element defined in the CDA Schema.TBD for more |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Health Status Value](ValueSet-HealthStatus.Value.VS.md) | SNOMED CT Health Status codes. |
| [Payer Role Codes](ValueSet-Payer.Role.Codes.VS.md) | TBD… |
| [Problem Status Observation Value](ValueSet-ProblemStatusObservation.Value.VS.md) | If coded, the Severity Entry value SHOULD use the HL7 SeverityObservation vocabulary (codeSystem='2.16.840.1.113883.5.1063') containing three values (H, M, and L), representing high, moderate and low severity depending upon whether the severity is life threatening, presents noticeable adverse consequences, or is unlikely substantially affect the situation of the subject. |
| [Severity Value Code VS](ValueSet-Severity.Value.Code.VS.md) | If coded, the Severity Entry value SHOULD use the HL7 SeverityObservation vocabulary (codeSystem='2.16.840.1.113883.5.1063') containing three values (H, M, and L), representing high, moderate and low severity depending upon whether the severity is life threatening, presents noticeable adverse consequences, or is unlikely substantially affect the situation of the subject. |

