# Health Status Value - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Status Value**

## ValueSet: Health Status Value 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/ValueSet/HealthStatus.Value.VS | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:HealthStatus_Value_VS |

 
SNOMED CT Health Status codes. 

 **References** 

* [Health Status](StructureDefinition-IHE.Health.Status.Observation.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 8 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "HealthStatus.Value.VS",
  "url" : "https://profiles.ihe.net/PCC/PSCc/ValueSet/HealthStatus.Value.VS",
  "version" : "0.0.1-current",
  "name" : "HealthStatus_Value_VS",
  "title" : "Health Status Value",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "SNOMED CT Health Status codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "81323004",
            "display" : "Alive and well"
          },
          {
            "code" : "313386006",
            "display" : "In remission"
          },
          {
            "code" : "162467007",
            "display" : "Symptom free"
          },
          {
            "code" : "161901003",
            "display" : "Chronically ill"
          },
          {
            "code" : "271593001",
            "display" : "Severely ill"
          },
          {
            "code" : "21134002",
            "display" : "Disabled"
          },
          {
            "code" : "161045001",
            "display" : "Severely disabled"
          },
          {
            "code" : "419099009",
            "display" : "Deceased"
          }
        ]
      }
    ]
  }
}

```
