# Coverage Entry - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage Entry**

## Logical Model: Coverage Entry 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Coverage.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_CDA_Coverage_Entry |

 
A Coverage Activity groups the policy and authorization acts within a Payers Section to order the payment sources. A Coverage Activity contains one or more Policy Activities, each of which contains zero or more Authorization Activities. The sequenceNumber/@value shows the policy order of preference. The Member Identifier is described in the contained Policy Activity Template 2.16.840.1.113883.10.20.22.4.61. 
^HL7 C_CDA description 
Payers shall be recorded as described in CCD: 3.1.2.1.1. ^IHE description 

**Usages:**

* Use this Logical Model Profile: [IHE Payers Section](StructureDefinition-IHE.PCC.CDA.Payers.Section.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.CDA.Coverage.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.CDA.Coverage.Entry.csv), [Excel](StructureDefinition-IHE.PCC.CDA.Coverage.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.CDA.Coverage.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Coverage.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_CDA_Coverage_Entry",
  "title" : "Coverage Entry",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "A Coverage Activity groups the policy and authorization acts within a Payers Section to order the payment sources. A Coverage Activity contains one or more Policy Activities, each of which contains zero or more Authorization Activities. \nThe sequenceNumber/@value shows the policy order of preference. \nThe Member Identifier is described in the contained Policy Activity Template 2.16.840.1.113883.10.20.22.4.61.\n\n^HL7 C_CDA description \n\nPayers shall be recorded as described in CCD: 3.1.2.1.1.\n^IHE description ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Coverage.Entry"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Coverage.Entry"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Act.templateId:coverage-entry",
        "path" : "Act.templateId",
        "sliceName" : "coverage-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:coverage-entry.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.17"
      },
      {
        "id" : "Act.templateId:coverage-act",
        "path" : "Act.templateId",
        "sliceName" : "coverage-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:coverage-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.20"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4537-8872).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4537-8873).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "short" : "Payment sources"
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "min" : 1,
        "patternCode" : "48768-6"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Coverage.Entry"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-8875).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:4537-19094).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.effectiveTime.value",
        "path" : "Act.effectiveTime.value",
        "mustSupport" : true
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:payer-entries",
        "path" : "Act.entryRelationship",
        "sliceName" : "payer-entries",
        "short" : "entryRelationship",
        "comment" : "SHALL contain at least one [1..*] entryRelationship (CONF:4537-8878) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:payer-entries.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4537-8879).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Act.entryRelationship:payer-entries.sequenceNumber",
        "path" : "Act.entryRelationship.sequenceNumber",
        "comment" : "MAY contain zero or one [0..1] sequenceNumber (CONF:4537-17174)."
      },
      {
        "id" : "Act.entryRelationship:payer-entries.sequenceNumber.value",
        "path" : "Act.entryRelationship.sequenceNumber.value",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:payer-entries.act",
        "path" : "Act.entryRelationship.act",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
            ]
          }
        ]
      }
    ]
  }
}

```
