# Payer Role Codes - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Payer Role Codes**

## ValueSet: Payer Role Codes 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/ValueSet/Payer.Role.Codes.VS | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:Payer_Role_Codes_VS |

 
TBD… 

 **References** 

* [Payers Entry](StructureDefinition-IHE.PCC.CDA.Payers.Entry.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [v3 Code System RoleCode](http://terminology.hl7.org/6.5.0/ValueSet-v3-RoleCode.html)
* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/ib`](http://terminology.hl7.org/6.5.0/CodeSystem-ib.html)version Not Stated (use latest from terminology server)
* Include all codes defined in [`http://snomed.info/sct`](http://www.snomed.org/)version Not Stated (use latest from terminology server)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "Payer.Role.Codes.VS",
  "url" : "https://profiles.ihe.net/PCC/PSCc/ValueSet/Payer.Role.Codes.VS",
  "version" : "0.0.1-current",
  "name" : "Payer_Role_Codes_VS",
  "title" : "Payer Role Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "TBD... ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-RoleCode"]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/ib"
      },
      {
        "system" : "http://snomed.info/sct"
      }
    ]
  }
}

```
