# Medical Document - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medical Document**

## Logical Model: Medical Document 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_MedicalDocument_CDA |

 
This Structure Definition defines the base set of constraints used by almost all medical document profiles described the PCC Technical Framework. 

**Usages:**

* Derived from this Logical Model Profile: [IHE Medical Summary CDA](StructureDefinition-IHE.PCC.MS.CDA.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.MD.CDA)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.MD.CDA.csv), [Excel](StructureDefinition-IHE.PCC.MD.CDA.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.MD.CDA",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_MedicalDocument_CDA",
  "title" : "Medical Document",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "This Structure Definition defines the base set of constraints used by almost all medical document profiles described the PCC Technical Framework.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "4537-6380",
            "severity" : "error",
            "human" : "If setId is present versionNumber **SHALL** be present (CONF:4537-6380).",
            "expression" : "setId.exists() implies versionNumber.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "4537-6387",
            "severity" : "error",
            "human" : "If versionNumber is present setId **SHALL** be present (CONF:4537-6387).",
            "expression" : "versionNumber.exists() implies setId.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-legalAuthenticator",
            "severity" : "warning",
            "human" : "SHOULD contain legalAuthenticator",
            "expression" : "legalAuthenticator.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-relatedParticipant",
            "severity" : "warning",
            "human" : "Documents SHOULD contain a RelatedPerson participant",
            "expression" : "AssociatedEntity.associatedPerson.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.classCode",
        "path" : "ClinicalDocument.classCode",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.realmCode",
        "path" : "ClinicalDocument.realmCode",
        "comment" : "SHALL contain at least one [1..1] realmCode=\" \". realmCode Should be UV",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.realmCode.code",
        "path" : "ClinicalDocument.realmCode.code",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-realmCode-1",
            "severity" : "error",
            "human" : "If realmCode is present it SHOULD be UV",
            "expression" : "realmCode.code.exists() implies realmCode.code.exists(value=#UV)",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.typeId",
        "path" : "ClinicalDocument.typeId",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.typeId.root",
        "path" : "ClinicalDocument.typeId.root",
        "comment" : "This typeId SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.1.3\" (CONF:4537-5250)."
      },
      {
        "id" : "ClinicalDocument.typeId.extension",
        "path" : "ClinicalDocument.typeId.extension",
        "comment" : "This typeId SHALL contain exactly one [1..1] @extension=\"POCD_HD000040\" (CONF:4537-5251)."
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-realmCode-2",
            "severity" : "error",
            "human" : "If realmCode is US, then the templateId SHALL be both 1.3.6.1.4.1.19376.1.5.3.1.1.1 and 2.16.840.1.113883.10.20.3",
            "expression" : "realmCode.code.exists(value=#US) implies templateId.us-realm.root.exists(value = 2.16.840.1.113883.10.20.22.1.1)",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.templateId:uv-realm",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "uv-realm",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.templateId:uv-realm.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.1.1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-realm",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "us-realm",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-realm.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-realm.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.id",
        "path" : "ClinicalDocument.id",
        "short" : "**SHALL** be a globally unique identifier for the document (CONF:4537-9991).",
        "comment" : "SHALL contain exactly one [1..1] id (CONF:4537-5363). The uniqueId can be formatted using the following XPath expression, where $docID in the expression below represents the identifier. concat($docID/@root, $docID/@extension)",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document type..",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystemName",
        "path" : "ClinicalDocument.sdtcCategory.codeSystemName",
        "min" : 1,
        "patternString" : "LOINC",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.displayName",
        "path" : "ClinicalDocument.sdtcCategory.displayName",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "**SHALL** specify the particular kind of document (e.g., History and Physical, Discharge Summary, Progress Note) (CONF:4537-9992).",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4537-5253)."
      },
      {
        "id" : "ClinicalDocument.code.nullFlavor",
        "path" : "ClinicalDocument.code.nullFlavor",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.code.code",
        "path" : "ClinicalDocument.code.code",
        "comment" : "The typeCode should be mapped from the ClinicalDocument/code element to a set of document type codes configured in the affinity domain. One suggested coding system to use for typeCode is LOINC, in which case the mapping step can be omitted.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.code.codeSystem",
        "path" : "ClinicalDocument.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.code.codeSystemName",
        "path" : "ClinicalDocument.code.codeSystemName",
        "min" : 1,
        "patternString" : "LOINC",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.code.displayName",
        "path" : "ClinicalDocument.code.displayName",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.title",
        "path" : "ClinicalDocument.title",
        "short" : "The title can either be a locally defined name or the displayName corresponding to clinicalDocument/code",
        "comment" : "SHALL contain exactly one [1..1] title (CONF:4537-5254).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.effectiveTime",
        "path" : "ClinicalDocument.effectiveTime",
        "comment" : "Times specified in clinical documents may be specified with a precision in fractional sections, and may contain a time zone offset. In the XDS Metadata, it can be precise to the second, and is always given in UTC, so the timezone offset if present must be added to the current time to obtain the UTC time.",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.confidentialityCode.nullFlavor",
        "path" : "ClinicalDocument.confidentialityCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.confidentialityCode.code",
        "path" : "ClinicalDocument.confidentialityCode.code",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-Confidentiality"
        }
      },
      {
        "id" : "ClinicalDocument.languageCode",
        "path" : "ClinicalDocument.languageCode",
        "comment" : "SHALL contain exactly one [1..1] languageCode, which SHALL be selected from ValueSet AllLanguages https://www.hl7.org/fhir/valueset-all-languages.html (OID 2.16.840.1.113883.4.642.3.21) DYNAMIC.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.setId",
        "path" : "ClinicalDocument.setId",
        "comment" : "MAY contain zero or one [0..1] setId (CONF:4537-5261)."
      },
      {
        "id" : "ClinicalDocument.versionNumber",
        "path" : "ClinicalDocument.versionNumber",
        "comment" : "MAY contain zero or one [0..1] versionNumber (CONF:4537-5264)."
      },
      {
        "id" : "ClinicalDocument.recordTarget",
        "path" : "ClinicalDocument.recordTarget",
        "short" : "The recordTarget records the administrative and demographic data of the patient whose health information is described by the clinical document; each recordTarget must contain at least one patientRole element",
        "comment" : "SHALL contain at least one [1..*] recordTarget (CONF:4537-5266).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole",
        "path" : "ClinicalDocument.recordTarget.patientRole",
        "comment" : "Such recordTargets SHALL contain exactly one [1..1] patientRole (CONF:4537-5267).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.id",
        "comment" : "This patientRole SHALL contain at least one [1..*] id (CONF:4537-5268).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.telecom",
        "path" : "ClinicalDocument.recordTarget.patientRole.telecom",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.telecom.use",
        "path" : "ClinicalDocument.recordTarget.patientRole.telecom.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient",
        "comment" : "This patientRole SHALL contain exactly one [1..1] patient (CONF:4537-5283).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "4537-32993",
            "severity" : "error",
            "human" : "If sdtc:deceasedInd=\"true\", then sdtc:deceasedTime **SHALL** be present with either a @value or @nullFlavor=UNK (CONF:4537-32993).",
            "expression" : "sdtcDeceasedInd.exists(value='true') implies sdtcDeceasedTime.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "4537-21000",
            "severity" : "error",
            "human" : "If sdtc:deceasedTime/@value is present, then sdtc:deceasedInd SHALL be present with value=true",
            "expression" : "sdtcDeceasedTime.value.exists() implies sdtcDeceasedInd.exists(value='true')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-us-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-maritalStatusCode",
            "severity" : "warning",
            "human" : "SHOULD contain maritalStatusCode",
            "expression" : "maritalStatusCode.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-us-languageCommunication",
            "severity" : "warning",
            "human" : "SHOULD contain languageCommunication",
            "expression" : "languageCommunication.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.name",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "iti-pdqm-patname",
            "severity" : "error",
            "human" : "Either Patient.name.given and/or Patient.name.family and/or Patient.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthTime",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthTime",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ts-shall-year",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the year",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 4",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "ts-should-day",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcDeceasedTime",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcDeceasedTime",
        "short" : "Date of Death",
        "constraint" : [
          {
            "key" : "should-value-att",
            "severity" : "warning",
            "human" : "SHOULD contain @value",
            "expression" : "value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "ts-shall-year",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the year",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 4",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "ts-should-day",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian",
        "constraint" : [
          {
            "key" : "should-us-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-us-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-us-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.code",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.code",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-PersonalAndLegalRelationshipRoleType"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.addr",
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom",
        "comment" : "The guardian, if present, SHOULD contain zero or more [0..*] telecom (CONF:4537-5382).",
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom.use",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson",
        "comment" : "The guardian, if present, SHALL contain exactly one [1..1] guardianPerson (CONF:4537-5385).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson.name",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace",
        "comment" : "This patient MAY contain zero or one [0..1] birthplace (CONF:4537-5395)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place",
        "comment" : "The birthplace, if present, SHALL contain exactly one [1..1] place (CONF:4537-5396)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr",
        "comment" : "This place SHALL contain exactly one [1..1] addr (CONF:4537-5397).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr.item.country",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr.item.country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-Country2"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication",
        "constraint" : [
          {
            "key" : "should-proficiencyLevelCode",
            "severity" : "warning",
            "human" : "SHOULD contain proficiencyLevelCode",
            "expression" : "proficiencyLevelCode.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-preferenceInd",
            "severity" : "warning",
            "human" : "SHOULD contain preferenceInd",
            "expression" : "preferenceInd.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.languageCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.languageCode",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/Languages"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization",
        "comment" : "This patientRole MAY contain zero or one [0..1] providerOrganization (CONF:4537-5416)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.id",
        "comment" : "The providerOrganization, if present, SHALL contain at least one [1..*] id (CONF:4537-5417).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.name",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.name",
        "comment" : "The providerOrganization, if present, SHALL contain at least one [1..*] name (CONF:4537-5419).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.telecom",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.telecom",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author",
        "path" : "ClinicalDocument.author",
        "short" : "The author element represents the creator of the clinical document.  The author may be a device or a person.",
        "comment" : "SHALL contain at least one [1..*] author (CONF:4537-5444)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor",
        "path" : "ClinicalDocument.author.assignedAuthor",
        "constraint" : [
          {
            "key" : "4537-16790",
            "severity" : "error",
            "human" : "There **SHALL** be exactly one assignedAuthor/assignedPerson or exactly one assignedAuthor/assignedAuthoringDevice (CONF:4537-16790).",
            "expression" : "(assignedPerson | assignedAuthoringDevice).count() = 1",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          },
          {
            "key" : "should-us-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id",
        "path" : "ClinicalDocument.author.assignedAuthor.id",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code",
        "path" : "ClinicalDocument.author.assignedAuthor.code",
        "short" : "Only if this assignedAuthor is an assignedPerson should the assignedAuthor contain a code.",
        "comment" : "This assignedAuthor SHOULD contain zero or one [0..1] code (CONF:4537-16787).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code.nullFlavor",
        "path" : "ClinicalDocument.author.assignedAuthor.code.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code.code",
        "path" : "ClinicalDocument.author.assignedAuthor.code.code",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.addr",
        "path" : "ClinicalDocument.author.assignedAuthor.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.telecom",
        "path" : "ClinicalDocument.author.assignedAuthor.telecom",
        "comment" : "This assignedAuthor SHALL contain at least one [1..*] telecom (CONF:4537-5428).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.telecom.use",
        "path" : "ClinicalDocument.author.assignedAuthor.telecom.use",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedPerson",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedPerson",
        "comment" : "MAY contain assignedPerson"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedPerson.name",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedPerson.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice",
        "comment" : "MAY contain assignedAuthoringDevice"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.manufacturerModelName",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.manufacturerModelName",
        "comment" : "The assignedAuthoringDevice, if present, SHALL contain exactly one [1..1] manufacturerModelName (CONF:4537-16784).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.softwareName",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.softwareName",
        "comment" : "The assignedAuthoringDevice, if present, SHALL contain exactly one [1..1] softwareName (CONF:4537-16785).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer",
        "path" : "ClinicalDocument.dataEnterer",
        "short" : "The dataEnterer element represents the person who transferred the content, written or dictated, into the clinical document. To clarify, an author provides the content found within the header or body of a document, subject to their own interpretation; a dataEnterer adds an author's information to the electronic system.",
        "comment" : "MAY contain zero or one [0..1] dataEnterer (CONF:4537-5441)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.time",
        "path" : "ClinicalDocument.dataEnterer.time",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity",
        "comment" : "The dataEnterer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-5442).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.id",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-5443)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.code",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-32173)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.addr",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.telecom",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4537-5466).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.telecom.use",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.telecom.use",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-5469).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-5470).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.informant",
        "path" : "ClinicalDocument.informant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "relatedEntity"
            },
            {
              "type" : "exists",
              "path" : "assignedEntity"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] informant (CONF:4537-31355) such that it"
      },
      {
        "id" : "ClinicalDocument.informant:provider",
        "path" : "ClinicalDocument.informant",
        "sliceName" : "provider",
        "short" : "The informant element describes an information source for any content within the clinical document. This informant is constrained for use when the source of information is an assigned health care provider for the patient.",
        "comment" : "MAY contain zero or more [0..*] informant (CONF:4537-8001) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity",
        "path" : "ClinicalDocument.informant.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-8002).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.id",
        "path" : "ClinicalDocument.informant.assignedEntity.id",
        "short" : "If assignedEntity/id is a provider then this id, **SHOULD** include zero or one [0..1] id where id/@root =\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-9946).",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-9945)."
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.code",
        "path" : "ClinicalDocument.informant.assignedEntity.code",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-NUCCProviderCodes"
        }
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.addr",
        "path" : "ClinicalDocument.informant.assignedEntity.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.informant.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-8221).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.informant.assignedEntity.assignedPerson.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.informant:provider.relatedEntity",
        "path" : "ClinicalDocument.informant.relatedEntity",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider",
        "path" : "ClinicalDocument.informant",
        "sliceName" : "non-provider",
        "short" : "The informant element describes an information source (who is not a provider) for any content within the clinical document. This informant would be used when the source of information has a personal relationship with the patient or is the patient.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.assignedEntity",
        "path" : "ClinicalDocument.informant.assignedEntity",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.relatedEntity",
        "path" : "ClinicalDocument.informant.relatedEntity",
        "comment" : "SHALL contain exactly one [1..1] relatedEntity (CONF:4537-31356).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.custodian",
        "path" : "ClinicalDocument.custodian",
        "short" : "The custodian element represents the organization that is in charge of maintaining and is entrusted with the care of the document.\n\n  There is only one custodian per CDA document. Allowing that a CDA document may not represent the original form of the authenticated document, the custodian represents the steward of the original source document. The custodian may be the document originator, a health information exchange, or other responsible party.",
        "comment" : "SHALL contain exactly one [1..1] custodian (CONF:4537-5519).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian",
        "path" : "ClinicalDocument.custodian.assignedCustodian",
        "comment" : "This custodian SHALL contain exactly one [1..1] assignedCustodian (CONF:4537-5520)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "comment" : "This assignedCustodian SHALL contain exactly one [1..1] representedCustodianOrganization (CONF:4537-5521)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id",
        "comment" : "This representedCustodianOrganization SHALL contain at least one [1..*] id (CONF:4537-5522)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.name",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.name",
        "comment" : "This representedCustodianOrganization SHALL contain exactly one [1..1] name (CONF:4537-5524).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom",
        "comment" : "This representedCustodianOrganization SHALL contain exactly one [1..1] telecom (CONF:4537-5525).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom.use",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom.use",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.sdtcTelecom",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.sdtcTelecom",
        "short" : "The stdc:telecom extension can be used to provide additional telecom elements for the custodian organization."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.addr",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "short" : "The informationRecipient element records the intended recipient of the information at the time the document was created. In cases where the intended recipient of the document is the patient's health chart, set the receivedOrganization to the scoping organization for that chart.",
        "comment" : "MAY contain zero or more [0..*] informationRecipient (CONF:4537-5565)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "comment" : "The informationRecipient, if present, SHALL contain exactly one [1..1] intendedRecipient (CONF:4537-5566)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "comment" : "This intendedRecipient MAY contain zero or more [0..*] id (CONF:4537-32399)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "comment" : "This intendedRecipient MAY contain zero or one [0..1] informationRecipient (CONF:4537-5567)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization",
        "comment" : "This intendedRecipient MAY contain zero or one [0..1] receivedOrganization (CONF:4537-5577)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.name",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.name",
        "comment" : "The receivedOrganization, if present, SHALL contain exactly one [1..1] name (CONF:4537-5578).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator",
        "path" : "ClinicalDocument.legalAuthenticator",
        "short" : "The legalAuthenticator identifies the single person legally responsible for the document and must be present if the document has been legally authenticated. A clinical document that does not contain this element has not been legally authenticated. The act of legal authentication requires a certain privilege be granted to the legal authenticator depending upon local policy. Based on local practice, clinical documents may be released before legal authentication.  All clinical documents have the potential for legal authentication, given the appropriate credentials. Local policies MAY choose to delegate the function of legal authentication to a device or system that generates the clinical document. In these cases, the legal authenticator is a person accepting responsibility for the document, not the generating device or system. Note that the legal authenticator, if present, must be a person.",
        "comment" : "SHOULD contain zero or one [0..1] legalAuthenticator (CONF:4537-5579).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.time",
        "path" : "ClinicalDocument.legalAuthenticator.time",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.signatureCode",
        "path" : "ClinicalDocument.legalAuthenticator.signatureCode",
        "comment" : "The legalAuthenticator, if present, SHALL contain exactly one [1..1] signatureCode (CONF:4537-5583)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.signatureCode.code",
        "path" : "ClinicalDocument.legalAuthenticator.signatureCode.code",
        "comment" : "This signatureCode SHALL contain exactly one [1..1] @code=\"S\" (CodeSystem: HL7ParticipationSignature urn:oid:2.16.840.1.113883.5.89 STATIC) (CONF:4537-5584).",
        "min" : 1,
        "patternCode" : "S",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.sdtcSignatureText",
        "path" : "ClinicalDocument.legalAuthenticator.sdtcSignatureText",
        "short" : "The signature can be represented either inline or by reference according to the ED data type. Typical cases for CDA are:\n1) Electronic signature: this attribute can represent virtually any electronic signature scheme.\n2) Digital signature: this attribute can represent digital signatures by reference to a signature data block that is constructed in accordance to a digital signature standard, such as XML-DSIG, PKCS#7, PGP, etc.\n The sdtc:signatureText extension provides a location in CDA for a textual or multimedia depiction of the signature by which the participant endorses and accepts responsibility for his or her participation in the Act as specified in the Participation.typeCode. Details of what goes in the field are described in the HL7 CDA Digital Signature Standard balloted in Fall 2013.",
        "comment" : "The legalAuthenticator, if present, MAY contain zero or one [0..1] sdtc:signatureText (CONF:4537-30810)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity",
        "comment" : "The legalAuthenticator, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-5585)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.id",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-5586)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.addr",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.addr",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5589).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4537-5595).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom.use",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom.use",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-5597).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator",
        "path" : "ClinicalDocument.authenticator",
        "short" : "The authenticator identifies a participant or participants who attest to the accuracy of the information in the document."
      },
      {
        "id" : "ClinicalDocument.authenticator.time",
        "path" : "ClinicalDocument.authenticator.time",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator.signatureCode",
        "path" : "ClinicalDocument.authenticator.signatureCode",
        "comment" : "SHALL contain exactly one [1..1] signatureCode (CONF:4537-5610)."
      },
      {
        "id" : "ClinicalDocument.authenticator.signatureCode.code",
        "path" : "ClinicalDocument.authenticator.signatureCode.code",
        "comment" : "This signatureCode SHALL contain exactly one [1..1] @code=\"S\" (CodeSystem: HL7ParticipationSignature urn:oid:2.16.840.1.113883.5.89 STATIC) (CONF:4537-5611).",
        "min" : 1,
        "patternCode" : "S",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator.sdtcSignatureText",
        "path" : "ClinicalDocument.authenticator.sdtcSignatureText",
        "short" : "The signature can be represented either inline or by reference according to the ED data type. Typical cases for CDA are:\n1) Electronic signature: this attribute can represent virtually any electronic signature scheme.\n2) Digital signature: this attribute can represent digital signatures by reference to a signature data block that is constructed in accordance to a digital signature standard, such as XML-DSIG, PKCS#7, PGP, etc.\n The sdtc:signatureText extension provides a location in CDA for a textual or multimedia depiction of the signature by which the participant endorses and accepts responsibility for his or her participation in the Act as specified in the Participation.typeCode. Details of what goes in the field are described in the HL7 CDA Digital Signature Standard balloted in Fall of 2013.",
        "comment" : "MAY contain zero or one [0..1] sdtc:signatureText (CONF:4537-30811)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity",
        "path" : "ClinicalDocument.authenticator.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-5612)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.id",
        "path" : "ClinicalDocument.authenticator.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-5613)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code.code",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code.code",
        "comment" : "The code, if present, MAY contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-16826)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.addr",
        "path" : "ClinicalDocument.authenticator.assignedEntity.addr",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.telecom",
        "path" : "ClinicalDocument.authenticator.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4537-5622).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.telecom.use",
        "path" : "ClinicalDocument.authenticator.assignedEntity.telecom.use",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-5624).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ihe-pcc-person-name",
            "severity" : "error",
            "human" : "Either Person.name.given and/or Person.name.family and/or Person.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "short" : "The participant element identifies supporting entities, including parents, relatives, caregivers, insurance policyholders, guarantors, and others related in some way to the patient. A supporting person or organization is an individual or an organization with a relationship to the patient. A supporting person who is playing multiple roles would be recorded in multiple participants (e.g., emergency contact and next-of-kin).",
        "comment" : "SHOULD contain zero or more [0..*] RelatedPerson participant",
        "constraint" : [
          {
            "key" : "4537-10006",
            "severity" : "error",
            "human" : "**SHALL** contain associatedEntity/associatedPerson *AND/OR* associatedEntity/scopingOrganization (CONF:4537-10006).",
            "expression" : "associatedEntity.associatedPerson.exists() or associatedEntity.scopingOrganization.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant.time",
        "path" : "ClinicalDocument.participant.time",
        "comment" : "MAY contain zero or one [0..1] time (CONF:4537-10004).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf",
        "path" : "ClinicalDocument.inFulfillmentOf",
        "short" : "The inFulfillmentOf element represents orders that are fulfilled by this document such as a radiologists' report of an x-ray.",
        "comment" : "MAY contain zero or more [0..*] inFulfillmentOf (CONF:4537-9952)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order",
        "path" : "ClinicalDocument.inFulfillmentOf.order",
        "comment" : "The inFulfillmentOf, if present, SHALL contain exactly one [1..1] order (CONF:4537-9953)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order.id",
        "path" : "ClinicalDocument.inFulfillmentOf.order.id",
        "comment" : "This order SHALL contain at least one [1..*] id (CONF:4537-9954).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "comment" : "MAY contain zero or more [0..*] documentationOf (CONF:4537-14835)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "short" : "A serviceEvent represents the main act being documented, such as a colonoscopy or a cardiac stress study. In a provision of healthcare serviceEvent, the care providers, PCP, or other longitudinal providers, are recorded within the serviceEvent. If the document is about a single encounter, the providers associated can be recorded in the componentOf/encompassingEncounter template.",
        "comment" : "The documentationOf, if present, SHALL contain exactly one [1..1] serviceEvent (CONF:4537-14836).",
        "constraint" : [
          {
            "key" : "should-us-performer",
            "severity" : "warning",
            "human" : "SHOULD contain performer",
            "expression" : "performer.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:4537-14838).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "short" : "The performer participant represents clinicians who actually and principally carry out the serviceEvent. In a transfer of care this represents the healthcare providers involved in the current or pertinent historical care of the patient. Preferably, the patient's key healthcare care team members would be listed, particularly their primary physician and any active consulting physicians, therapists, and counselors.",
        "comment" : "This serviceEvent SHOULD contain zero or more [0..*] performer (CONF:4537-14839).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "comment" : "The performer, if present, MAY contain zero or one [0..1] functionCode (CONF:4537-16818).",
        "constraint" : [
          {
            "key" : "should-code-attr",
            "severity" : "warning",
            "human" : "SHOULD contain @code",
            "expression" : "code.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.time",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.time",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-14841).",
        "constraint" : [
          {
            "key" : "should-us-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-14846)."
      },
      {
        "id" : "ClinicalDocument.authorization",
        "path" : "ClinicalDocument.authorization",
        "short" : "The authorization element represents information about the patient's consent. The type of consent is conveyed in consent/code. Consents in the header have been finalized (consent/statusCode must equal Completed) and should be on file. This specification does not address how 'Privacy Consent' is represented, but does not preclude the inclusion of 'Privacy Consent'. The authorization consent is used for referring to consents that are documented elsewhere in the EHR or medical record for a health condition and/or treatment that is described in the CDA document.",
        "comment" : "MAY contain zero or more [0..*] authorization (CONF:4537-16792) such that it"
      },
      {
        "id" : "ClinicalDocument.authorization.consent",
        "path" : "ClinicalDocument.authorization.consent",
        "comment" : "SHALL contain exactly one [1..1] consent (CONF:4537-16793).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authorization.consent.id",
        "path" : "ClinicalDocument.authorization.consent.id",
        "comment" : "This consent MAY contain zero or more [0..*] id (CONF:4537-16794)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.code",
        "path" : "ClinicalDocument.authorization.consent.code",
        "short" : "The type of consent (e.g., a consent to perform the related serviceEvent) is conveyed in consent/code.",
        "comment" : "This consent MAY contain zero or one [0..1] code (CONF:4537-16795)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.statusCode",
        "path" : "ClinicalDocument.authorization.consent.statusCode",
        "comment" : "This consent SHALL contain exactly one [1..1] statusCode (CONF:4537-16797).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.authorization.consent.statusCode.code",
        "path" : "ClinicalDocument.authorization.consent.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:4537-16798)."
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "The encompassing encounter represents the setting of the clinical encounter during which the document act(s) or ServiceEvent(s) occurred. In order to represent providers associated with a specific encounter, they are recorded within the encompassingEncounter as participants. In a CCD, the encompassingEncounter may be used when documenting a specific encounter and its participants. All relevant encounters in a CCD may be listed in the encounters section.",
        "comment" : "MAY contain zero or one [0..1] componentOf (CONF:4537-9955).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "The componentOf, if present, SHALL contain exactly one [1..1] encompassingEncounter (CONF:4537-9956).",
        "constraint" : [
          {
            "key" : "should-responsibleParty",
            "severity" : "warning",
            "human" : "SHOULD contain responsibleParty",
            "expression" : "responsibleParty.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "comment" : "This encompassingEncounter SHALL contain at least one [1..*] id (CONF:4537-9959).",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "short" : "The responsibleParty element records only the party responsible for the encounter, not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter SHOULD contain zero or one [0..1] responsibleParty (CONF:1198-8391).",
        "constraint" : [
          {
            "key" : "1198-8348",
            "severity" : "error",
            "human" : "The responsibleParty element, if present, **SHALL** contain an assignedEntity element, which **SHALL** contain an assignedPerson element, a representedOrganization element, or both (CONF:1198-8348).",
            "expression" : "assignedEntity.assignedPerson.exists() or assignedEntity.representedOrganization.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty.assignedEntity",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty.assignedEntity",
        "comment" : "The responsibleParty, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32904).",
        "constraint" : [
          {
            "key" : "1198-32905",
            "severity" : "error",
            "human" : "This assignedEntity SHALL contain an assignedPerson or a representedOrganization or both (CONF:1198-32905).",
            "expression" : "assignedPerson.exists() or representedOrganization.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "short" : "The encounterParticipant elements represent only those participants in the encounter, not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter MAY contain zero or more [0..*] encounterParticipant (CONF:1198-8342).",
        "constraint" : [
          {
            "key" : "1198-8348",
            "severity" : "error",
            "human" : "The responsibleParty element, if present, **SHALL** contain an assignedEntity element, which **SHALL** contain an assignedPerson element, a representedOrganization element, or both (CONF:1198-8348).",
            "expression" : "assignedEntity.assignedPerson.exists() or assignedEntity.representedOrganization.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.location",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.location",
        "comment" : "This encompassingEncounter MAY contain zero or one [0..1] location (CONF:1198-8344).",
        "mustSupport" : true
      }
    ]
  }
}

```
