# Comments - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Comments**

## Logical Model: Comments 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Comment.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_Comment_Entry |

 
This entry allows for a comment to be supplied with each entry. For CDA this structure is usually included in the target act using theelement defined in the CDA Schema, but can also be used in theelement when the comment appears within an. The example below shows recording a comment for an, and is used as context for the following sections. For HL7 Version 3 Messages, this relationship is represented with the element, although the remainder of the typecodes and semantics are unchanged. 
Any condition or allergy may be the subject of a comment. 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.Comment.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.Comment.Entry.csv), [Excel](StructureDefinition-IHE.PCC.Comment.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.Comment.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Comment.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_Comment_Entry",
  "title" : "Comments",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "This entry allows for a comment to be supplied with each entry. For CDA this structure is usually included in the target act using the <entryRelationship> element defined in the CDA Schema, but can also be used in the <component> element when the comment appears within an <organizer>. The example below shows recording a comment for an <entry>, and is used as context for the following sections. For HL7 Version 3 Messages, this relationship is represented with the element <sourceOf>, although the remainder of the typecodes and semantics are unchanged.\n\nAny condition or allergy may be the subject of a comment.\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Comment.Entry"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Comment.Entry"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Act.templateId:comment-activity",
        "path" : "Act.templateId",
        "sliceName" : "comment-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:comment-activity.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.40"
      },
      {
        "id" : "Act.templateId:comment-entry",
        "path" : "Act.templateId",
        "sliceName" : "comment-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:comment-entry.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.2"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:81-9425).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:81-9426).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:81-9428)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"48767-8\" Annotation Comment (CONF:81-19159).",
        "min" : 1,
        "patternCode" : "48767-8"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.1\" (CodeSystem: LOINC urn:oid:2.16.840.1.113883.6.1) (CONF:81-26501).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "comment" : "SHALL contain exactly one [1..1] text (CONF:81-9430).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "comment" : "This text SHALL contain exactly one [1..1] reference (CONF:81-15967).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Comment.Entry"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Act.text.reference.value",
        "path" : "Act.text.reference.value",
        "comment" : "This reference SHALL contain exactly one [1..1] @value (CONF:81-15968).",
        "min" : 1
      },
      {
        "id" : "Act.author.time",
        "path" : "Act.author.time",
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor",
        "path" : "Act.author.assignedAuthor",
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.id",
        "path" : "Act.author.assignedAuthor.id",
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.addr",
        "path" : "Act.author.assignedAuthor.addr",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.telecom",
        "path" : "Act.author.assignedAuthor.telecom",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.assignedPerson",
        "path" : "Act.author.assignedAuthor.assignedPerson",
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.assignedPerson.name",
        "path" : "Act.author.assignedAuthor.assignedPerson.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.representedOrganization",
        "path" : "Act.author.assignedAuthor.representedOrganization",
        "mustSupport" : true
      },
      {
        "id" : "Act.author.assignedAuthor.representedOrganization.name",
        "path" : "Act.author.assignedAuthor.representedOrganization.name",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
