# Payers Entry - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Payers Entry**

## Logical Model: Payers Entry 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_CDA_Payers_Entry |

 
The payer entry allows information about the patient's sources of payment to be recorded. 
TBD if more 

**Usages:**

* Use this Logical Model Profile: [Coverage Entry](StructureDefinition-IHE.PCC.CDA.Coverage.Entry.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.CDA.Payers.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.CDA.Payers.Entry.csv), [Excel](StructureDefinition-IHE.PCC.CDA.Payers.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.CDA.Payers.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_CDA_Payers_Entry",
  "title" : "Payers Entry",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "The payer entry allows information about the patient's sources of payment to be recorded.\n\nTBD if more",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Act.templateId:payer-act",
        "path" : "Act.templateId",
        "sliceName" : "payer-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:payer-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.26"
      },
      {
        "id" : "Act.templateId:payers-entry",
        "path" : "Act.templateId",
        "sliceName" : "payers-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:payers-entry.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.18"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4537-8872).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4537-8873).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "If the root OID of Payer that assigned the identifier is unknown, a local OID can be assigned or a nullFlavor of UNK",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "The <code> element should be present, and represents the type of coverage provided by the payer. Potential vocabularies to use include: HL7 ActCoverageType (2.16.840.1.113883.5.4) and X12 Data Element 1336 (2.16.840.1.113883.6.255.1336)",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActCoverageTypeCode"
        }
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.performer",
        "path" : "Act.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "templateId.root"
            }
          ],
          "rules" : "open"
        },
        "comment" : "The <performer> element shall be present to represent the payer of the coverage.",
        "min" : 1
      },
      {
        "id" : "Act.performer:payer",
        "path" : "Act.performer",
        "sliceName" : "payer",
        "short" : "This performer represents the Payer.",
        "comment" : "SHALL contain exactly one [1..1] performer (CONF:4537-8906) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.performer:payer.typeCode",
        "path" : "Act.performer.typeCode",
        "min" : 1
      },
      {
        "id" : "Act.performer:payer.assignedEntity",
        "path" : "Act.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-8908).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          },
          {
            "key" : "should-representedOrganization",
            "severity" : "warning",
            "human" : "SHOULD contain representedOrganization",
            "expression" : "representedOrganization.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.classCode",
        "path" : "Act.performer.assignedEntity.classCode",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.performer:payer.assignedEntity.id",
        "path" : "Act.performer.assignedEntity.id",
        "mustSupport" : true
      },
      {
        "id" : "Act.performer:payer.assignedEntity.code",
        "path" : "Act.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code (CONF:4537-8914)."
      },
      {
        "id" : "Act.performer:payer.assignedEntity.code.nullFlavor",
        "path" : "Act.performer.assignedEntity.code.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.performer:payer.assignedEntity.code.code",
        "path" : "Act.performer.assignedEntity.code.code",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://profiles.ihe.net/PCC/PSCc/ValueSet/Payer.Role.Codes.VS"
        }
      },
      {
        "id" : "Act.performer:payer.assignedEntity.addr",
        "path" : "Act.performer.assignedEntity.addr",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.telecom",
        "path" : "Act.performer.assignedEntity.telecom",
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.telecom.use",
        "path" : "Act.performer.assignedEntity.telecom.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.performer:payer.assignedEntity.representedOrganization",
        "path" : "Act.performer.assignedEntity.representedOrganization",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] representedOrganization (CONF:4537-8912).",
        "constraint" : [
          {
            "key" : "should-name",
            "severity" : "warning",
            "human" : "SHOULD contain name",
            "expression" : "name.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:payer.assignedEntity.representedOrganization.classCode",
        "path" : "Act.performer.assignedEntity.representedOrganization.classCode",
        "min" : 1
      },
      {
        "id" : "Act.performer:payer.assignedEntity.representedOrganization.name",
        "path" : "Act.performer.assignedEntity.representedOrganization.name",
        "comment" : "The representedOrganization, if present, SHOULD contain zero or one [0..1] name (CONF:4537-8913).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.performer:guarantor",
        "path" : "Act.performer",
        "sliceName" : "guarantor",
        "short" : "This performer represents the Guarantor.",
        "min" : 0,
        "max" : "*",
        "constraint" : [
          {
            "key" : "should-time",
            "severity" : "warning",
            "human" : "SHOULD contain time",
            "expression" : "time.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.typeCode",
        "path" : "Act.performer.typeCode",
        "min" : 1
      },
      {
        "id" : "Act.performer:guarantor.time",
        "path" : "Act.performer.time",
        "comment" : "SHOULD contain zero or one [0..1] time (CONF:4537-8963)."
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity",
        "path" : "Act.performer.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-8962).",
        "constraint" : [
          {
            "key" : "4537-8967",
            "severity" : "warning",
            "human" : "**SHOULD** include assignedEntity/assignedPerson/name AND/OR assignedEntity/representedOrganization/name (CONF:4537-8967).",
            "expression" : "assignedPerson.name.exists() or representedOrganization.name.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          },
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.code",
        "path" : "Act.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] code (CONF:4537-8968).",
        "min" : 1
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.code.code",
        "path" : "Act.performer.assignedEntity.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"GUAR\" Guarantor (CONF:4537-16096).",
        "min" : 1,
        "patternCode" : "GUAR"
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.code.codeSystem",
        "path" : "Act.performer.assignedEntity.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.110\" (CONF:4537-32165).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.110"
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.addr",
        "path" : "Act.performer.assignedEntity.addr",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-8964).",
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.telecom",
        "path" : "Act.performer.assignedEntity.telecom",
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.performer:guarantor.assignedEntity.telecom.use",
        "path" : "Act.performer.assignedEntity.telecom.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.participant",
        "path" : "Act.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or one [0..1] participant (CONF:4537-8934) such that it",
        "min" : 1
      },
      {
        "id" : "Act.participant:member",
        "path" : "Act.participant",
        "sliceName" : "member",
        "short" : "participant",
        "comment" : "SHALL contain exactly one [1..1] participant (CONF:4537-8916) such that it",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-time",
            "severity" : "warning",
            "human" : "SHOULD contain time",
            "expression" : "time.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:member.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COV\" Coverage target (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:4537-8917).",
        "fixedCode" : "COV"
      },
      {
        "id" : "Act.participant:member.time",
        "path" : "Act.participant.time",
        "short" : "This records the policy coverage period or self-pay period.",
        "comment" : "SHOULD contain zero or one [0..1] time (CONF:4537-8918).",
        "constraint" : [
          {
            "key" : "should-low",
            "severity" : "warning",
            "human" : "SHOULD contain low",
            "expression" : "low.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          },
          {
            "key" : "should-high",
            "severity" : "warning",
            "human" : "SHOULD contain high",
            "expression" : "high.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:member.time.low",
        "path" : "Act.participant.time.low",
        "comment" : "The time, if present, SHOULD contain zero or one [0..1] low (CONF:4537-8919)."
      },
      {
        "id" : "Act.participant:member.time.high",
        "path" : "Act.participant.time.high",
        "short" : "SHOULD contain high",
        "comment" : "The time, if present, SHOULD contain zero or one [0..1] high (CONF:4537-8920)."
      },
      {
        "id" : "Act.participant:member.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4537-8921).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          },
          {
            "key" : "should-playingEntity",
            "severity" : "warning",
            "human" : "SHOULD contain playingEntity",
            "expression" : "playingEntity.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:member.participantRole.id",
        "path" : "Act.participant.participantRole.id",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:4537-8922).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.participant:member.participantRole.code",
        "path" : "Act.participant.participantRole.code",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-code-attr",
            "severity" : "warning",
            "human" : "SHOULD contain @code",
            "expression" : "code.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Act.participant:member.participantRole.code.code",
        "path" : "Act.participant.participantRole.code.code",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://profiles.ihe.net/PCC/PSCc/ValueSet/Payer.Role.Codes.VS"
        }
      },
      {
        "id" : "Act.participant:member.participantRole.addr",
        "path" : "Act.participant.participantRole.addr",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Act.participant:member.participantRole.telecom",
        "path" : "Act.participant.participantRole.telecom",
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:member.participantRole.telecom.use",
        "path" : "Act.participant.participantRole.telecom.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.participant:member.participantRole.playingEntity",
        "path" : "Act.participant.participantRole.playingEntity",
        "short" : "This playingEntity records the covered party name and birthTime as represented by the health plan. This could match the information in recordTarget, or be different due to marriage or other reasons.",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] playingEntity (CONF:4537-8932)."
      },
      {
        "id" : "Act.participant:member.participantRole.playingEntity.name",
        "path" : "Act.participant.participantRole.playingEntity.name",
        "comment" : "The playingEntity, if present, SHALL contain exactly one [1..1] name (CONF:4537-8930).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.participant:member.participantRole.playingEntity.sdtcBirthTime",
        "path" : "Act.participant.participantRole.playingEntity.sdtcBirthTime",
        "short" : "sdtc:birthTime",
        "comment" : "The playingEntity, if present, SHALL contain exactly one [1..1] sdtc:birthTime (CONF:4537-31344).",
        "min" : 1
      },
      {
        "id" : "Act.participant:subscriber",
        "path" : "Act.participant",
        "sliceName" : "subscriber",
        "short" : "When the Subscriber is the patient, the participant element describing the subscriber *SHALL NOT* be present. This information will be recorded instead in the data elements used to record member information.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Act.participant:subscriber.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"HLD\" Holder (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:4537-8935).",
        "fixedCode" : "HLD"
      },
      {
        "id" : "Act.participant:subscriber.time",
        "path" : "Act.participant.time",
        "comment" : "MAY contain zero or one [0..1] time (CONF:4537-8938)."
      },
      {
        "id" : "Act.participant:subscriber.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:4537-8936).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:subscriber.participantRole.id",
        "path" : "Act.participant.participantRole.id",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:4537-8937).",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Act.participant:subscriber.participantRole.addr",
        "path" : "Act.participant.participantRole.addr",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:subscriber.participantRole.telecom",
        "path" : "Act.participant.participantRole.telecom",
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Entry"
          }
        ]
      },
      {
        "id" : "Act.participant:subscriber.participantRole.telecom.use",
        "path" : "Act.participant.participantRole.telecom.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "act.moodCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Act.entryRelationship:plan",
        "path" : "Act.entryRelationship",
        "sliceName" : "plan",
        "short" : "Represents the Coverage Plan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plan.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plan.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "A description of the coverage plan **SHALL** contain one or more act/id, to represent the plan identifier, and an act/text with the name of the plan (CONF:4537-8943).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:plan.act.classCode",
        "path" : "Act.entryRelationship.act.classCode",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.entryRelationship:plan.act.moodCode",
        "path" : "Act.entryRelationship.act.moodCode",
        "fixedCode" : "DEF"
      },
      {
        "id" : "Act.entryRelationship:plan.act.id",
        "path" : "Act.entryRelationship.act.id",
        "short" : "Plan identifier",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.entryRelationship:plan.act.text",
        "path" : "Act.entryRelationship.act.text",
        "short" : "Name of the plan",
        "min" : 1
      }
    ]
  }
}

```
