# Health Status - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Status**

## Logical Model: Health Status 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Health.Status.Observation | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_Health_Status_Observation |

 
A problem observation may reference a health status observation. This structure is included in the target observation using theelement defined in the CDA Schema. The health status observation records information about the current health status of the patient. The example below shows the recording the health status, and is used as the context for the following sections. 

**Usages:**

* Use this Logical Model Profile: [Problem Entry](StructureDefinition-IHE.PCC.Problem.Entry.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.Health.Status.Observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.Health.Status.Observation.csv), [Excel](StructureDefinition-IHE.Health.Status.Observation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.Health.Status.Observation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Health.Status.Observation",
  "version" : "0.0.1-current",
  "name" : "IHE_Health_Status_Observation",
  "title" : "Health Status",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "A problem observation may reference a health status observation. This structure is included in the target observation using the <entryRelationship> element defined in the CDA Schema. The health status observation records information about the current health status of the patient. The example below shows the recording the health status, and is used as the context for the following sections.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Health.Status.Observation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Observation.templateId:prob-health-status-obs",
        "path" : "Observation.templateId",
        "sliceName" : "prob-health-status-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:prob-health-status-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.51"
      },
      {
        "id" : "Observation.templateId:health-status-obs",
        "path" : "Observation.templateId",
        "sliceName" : "health-status-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:health-status-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.1.2"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-9057).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1098-9072).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-32486).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-19143)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"11323-3\" Health status (CONF:1098-19144).",
        "min" : 1,
        "patternCode" : "11323-3"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.1\" (CodeSystem: LOINC urn:oid:2.16.840.1.113883.6.1) (CONF:1098-32161).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.code.codeSystemName",
        "path" : "Observation.code.codeSystemName",
        "patternString" : "LOINC"
      },
      {
        "id" : "Observation.code.displayName",
        "path" : "Observation.code.displayName",
        "patternString" : "Health Status"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry"
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Health.Status.Observation"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "The code attribute of <statusCode> for all clinical status observations shall be completed. While the <statusCode> element is required in all acts to record the status of the act, the only sensible value of this element in this context is completed.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1098-19103).",
        "min" : 1,
        "fixedCode" : "completed",
        "mustSupport" : true
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "The value of @code SHALL be drawn from value set 1.3.6.1.4.1.19376.1.5.3.1.11.3 HealthStatus_value (2016‑09‑26 14:09:34)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://profiles.ihe.net/PCC/PSCc/ValueSet/HealthStatus.Value.VS"
        }
      }
    ]
  }
}

```
