# IHE Allergies and Intolerances Entry - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE Allergies and Intolerances Entry**

## Logical Model: IHE Allergies and Intolerances Entry 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Allergies.And.Intolerances.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_Allergies_And_Intolerances_Entry |

 
Allergies and intolerances are special kinds of problems, and so are also recorded in the CDAelement, with classCode='OBS'. They follow the same pattern as the problem entry, with exceptions noted. 
TBD Still needs to be finished building Troubleshooting for comment needs to be done 

**Usages:**

* Use this Logical Model Profile: [IHE Concern Entry](StructureDefinition-IHE.PCC.Concern.Entry.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.Allergies.And.Intolerances.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.Allergies.And.Intolerances.Entry.csv), [Excel](StructureDefinition-IHE.Allergies.And.Intolerances.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.Allergies.And.Intolerances.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Allergies.And.Intolerances.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_Allergies_And_Intolerances_Entry",
  "title" : "IHE Allergies and Intolerances Entry",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "Allergies and intolerances are special kinds of problems, and so are also recorded in the CDA <observation> element, with classCode='OBS'. They follow the same pattern as the problem entry, with exceptions noted.\n\nTBD Still needs to be finished building Troubleshooting for comment needs to be done ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "min" : 3
      },
      {
        "id" : "Observation.templateId:ihe-prob-concern-entry",
        "path" : "Observation.templateId",
        "sliceName" : "ihe-prob-concern-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:ihe-prob-concern-entry.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.6"
      },
      {
        "id" : "Observation.negationInd",
        "path" : "Observation.negationInd",
        "short" : "Use negationInd=\"true\" to indicate that the allergy was not observed.",
        "comment" : "MAY contain zero or one [0..1] @negationInd (CONF:1098-31526)."
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ObservationIntoleranceType"
        }
      },
      {
        "id" : "Observation.participant",
        "path" : "Observation.participant",
        "mustSupport" : true
      },
      {
        "id" : "Observation.participant.typeCode",
        "path" : "Observation.participant.typeCode",
        "patternCode" : "CSM"
      },
      {
        "id" : "Observation.participant.participantRole.classCode",
        "path" : "Observation.participant.participantRole.classCode",
        "patternCode" : "MANU"
      },
      {
        "id" : "Observation.participant.participantRole.playingEntity.classCode",
        "path" : "Observation.participant.participantRole.playingEntity.classCode",
        "patternCode" : "MMAT"
      },
      {
        "id" : "Observation.entryRelationship:reactions",
        "path" : "Observation.entryRelationship",
        "sliceName" : "reactions",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:reactions.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "fixedCode" : "MFST"
      },
      {
        "id" : "Observation.entryRelationship:reactions.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "fixedBoolean" : false
      },
      {
        "id" : "Observation.entryRelationship:reactions.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "with this entry an additional OID of (2.16.840.1.113883.10.20.1.54) SHALL be used, indicating that this problem is a reaction.",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Problem.Reaction.Entry"
            ]
          }
        ]
      }
    ]
  }
}

```
