# Problem Status Observation Value - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problem Status Observation Value**

## ValueSet: Problem Status Observation Value 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/ValueSet/ProblemStatusObservation.Value.VS | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:ProblemStatusObservation_Value_VS |

 
If coded, the Severity Entry value SHOULD use the HL7 SeverityObservation vocabulary (codeSystem='2.16.840.1.113883.5.1063') containing three values (H, M, and L), representing high, moderate and low severity depending upon whether the severity is life threatening, presents noticeable adverse consequences, or is unlikely substantially affect the situation of the subject. 

 **References** 

* [Problem Status Observation](StructureDefinition-IHE.Problem.Status.Observation.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 8 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ProblemStatusObservation.Value.VS",
  "url" : "https://profiles.ihe.net/PCC/PSCc/ValueSet/ProblemStatusObservation.Value.VS",
  "version" : "0.0.1-current",
  "name" : "ProblemStatusObservation_Value_VS",
  "title" : "Problem Status Observation Value",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "If coded, the Severity Entry value SHOULD use the HL7 SeverityObservation vocabulary (codeSystem='2.16.840.1.113883.5.1063') containing three values (H, M, and L), representing high, moderate and low severity depending upon whether the severity is life threatening, presents noticeable adverse consequences, or is unlikely substantially affect the situation of the subject.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "55561003",
            "display" : "Active"
          },
          {
            "code" : "73425007",
            "display" : "Inactive"
          },
          {
            "code" : "90734009",
            "display" : "Chronic"
          },
          {
            "code" : "7087005",
            "display" : "Intermittent"
          },
          {
            "code" : "255227004",
            "display" : "Recurrent"
          },
          {
            "code" : "415684004",
            "display" : "Rule out"
          },
          {
            "code" : "410516002",
            "display" : "Ruled out"
          },
          {
            "code" : "413322009",
            "display" : "Resolved"
          }
        ]
      }
    ]
  }
}

```
