# Problem Entry - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problem Entry**

## Logical Model: Problem Entry 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_Problem_Entry |

 
This section makes use of the linking, severity, clinical status and comment content specifications defined elsewhere in the technical framework. In HL7 RIM parlance, observations about a problem, complaint, symptom, finding, diagnosis, or functional limitation of a patient is the event (moodCode='EVN') of observing () that problem. Theof the observation comes from a controlled vocabulary representing such things. The`contained within thedescribes the method of determination from yet another controlled vocabulary. An example appears below in the figure below` 
The basic pattern for reporting a problem uses the CDAelement, setting the classCode='OBS' to represent that this is an observation of a problem, and the moodCode='EVN', to represent that this is an observation that has in fact taken place. The negationInd attribute, if true, specifies that the problem indicated was observed to not have occurred (which is subtly but importantly different from having not been observed). 
The value of negationInd should not normally be set to true. Instead, to record that there is 'no prior history of chicken pox', one would use a coded value indicated exactly that. However, it is not always possible to record problems in this manner, especially if using a controlled vocabulary that does not supply pre-coordinated negations, or which do not allow the negation to be recorded with post-coordinated coded terminology. 
TBD for more 

**Usages:**

* Derived from this Logical Model Profile: [IHE Allergies and Intolerances Entry](StructureDefinition-IHE.Allergies.And.Intolerances.Entry.md) and [IHE Probelm Reaction Entry](StructureDefinition-IHE.Problem.Reaction.Entry.md)
* Use this Logical Model Profile: [IHE Concern Entry](StructureDefinition-IHE.PCC.Concern.Entry.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.Problem.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.Problem.Entry.csv), [Excel](StructureDefinition-IHE.PCC.Problem.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.Problem.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_Problem_Entry",
  "title" : "Problem Entry",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "This section makes use of the linking, severity, clinical status and comment content specifications defined elsewhere in the technical framework. In HL7 RIM parlance, observations about a problem, complaint, symptom, finding, diagnosis, or functional limitation of a patient is the event (moodCode='EVN') of observing (<observation classCode='OBS'>) that problem. The <value> of the observation comes from a controlled vocabulary representing such things. The <code> contained within the <observation> describes the method of determination from yet another controlled vocabulary. An example appears below in the figure below\n\nThe basic pattern for reporting a problem uses the CDA <observation> element, setting the classCode='OBS' to represent that this is an observation of a problem, and the moodCode='EVN', to represent that this is an observation that has in fact taken place. The negationInd attribute, if true, specifies that the problem indicated was observed to not have occurred (which is subtly but importantly different from having not been observed).\n\nThe value of negationInd should not normally be set to true. Instead, to record that there is 'no prior history of chicken pox', one would use a coded value indicated exactly that. However, it is not always possible to record problems in this manner, especially if using a controlled vocabulary that does not supply pre-coordinated negations, or which do not allow the negation to be recorded with post-coordinated coded terminology. \n\n\nTBD for more",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Observation.templateId:problem-obs",
        "path" : "Observation.templateId",
        "sliceName" : "problem-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:problem-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.28"
      },
      {
        "id" : "Observation.templateId:problem-entry",
        "path" : "Observation.templateId",
        "sliceName" : "problem-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:problem-entry.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.5"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-9042).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.negationInd",
        "path" : "Observation.negationInd",
        "short" : "The negationInd is used to indicate the absence of the condition in observation/value. A negationInd of \"true\" coupled with an observation/value of SNOMED code 64572001 \"Disease (disorder)\" indicates that the patient has no known conditions.",
        "comment" : "MAY contain zero or one [0..1] @negationInd (CONF:1198-10139).",
        "mustSupport" : true
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-9043).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "The <code> describes the process of establishing a problem. The code element should be used, as the process of determining the value is important to clinicians (e.g., a diagnosis is a more advanced statement than a symptom). When a physical exam observation is being recorded the code used should be “Finding.” When a review of systems observation is being recorded the code used should be “Symptom.” The recommended vocabulary for describing problems is shown in the table below. Subclasses of this content module may specify other vocabularies. When the list below is used, the codeSystem is '2.16.840.1.113883.6.96' and codeSystemName is SNOMED CT.",
        "mustSupport" : true
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "comment" : "The <text> element is required and points to the text describing the problem being recorded; including any dates, comments, et cetera. The <reference> contains a URI in value attribute. This URI points to the free text description of the problem in the document that is being described.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-9049).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "A clinical document normally records only those condition observation events that have been completed, not observations that are in any other state. Therefore, the <statusCode> shall always have code='completed'.",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "If the problem is known to be resolved, but the date of resolution is not known, then the high element **SHALL** be present, and the nullFlavor attribute **SHALL** be set to 'UNK'. Therefore, the existence of a high element within a problem does indicate that the problem has been resolved.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1198-9050).",
        "mustSupport" : true
      },
      {
        "id" : "Observation.effectiveTime.low",
        "path" : "Observation.effectiveTime.low",
        "short" : "The effectiveTime/low (a.k.a. \"onset date\") asserts when the condition became biologically active.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-15603).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.effectiveTime.high",
        "path" : "Observation.effectiveTime.high",
        "mustSupport" : true
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "The <value> is the condition that was found. This element is required. While the value may be a coded or an un-coded string, the type is always a coded value (xsi:type='CD'). If coded, the code and codeSystem attributes shall be present. The codeSystem should reference a controlled vocabulary describing problems, complaints, symptoms, findings, diagnoses, or functional limitations, e.g., ICD-9, SNOMED-CT or MEDCIN, or others.",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value.code",
        "path" : "Observation.value.code",
        "short" : "A negationInd of \"true\" coupled with an observation/value/@code of SNOMED code 64572001 \"Disease (disorder)\" indicates that the patient has no known conditions.  When the Problem is Social Determinant of Health Observation, the observation/value SHOULD be a SNOMED code selected from ValueSet Social Determinant of Health Conditions 2.16.840.1.113762.1.4.1196.788 DYNAMIC (CONF:4515-32951).",
        "comment" : "This value MAY contain zero or one [0..1] @code (CONF:1198-31871)."
      },
      {
        "id" : "Observation.value.qualifier",
        "path" : "Observation.value.qualifier",
        "short" : "The observation/value and all the qualifiers together (often referred to as a post-coordinated expression) make up one concept. Qualifiers constrain the meaning of the primary code, and cannot negate it or change its meaning. Qualifiers can only be used according to well-defined rules of post-coordination and only if the underlying code system defines the use of such qualifiers or if there is a third code system that specifies how other code systems may be combined.\n\n In cases where SNOMED CT does not have a precoordinated code that would be appropriate for the problem list, concept post coordination may be used in CDA following the principles outlined in HL7 Version 3 Implementation Guide: TermInfo -\nUsing SNOMED CT in CDA R2 Models, Release 1 using the V3 CD Data type 1 style.  This is shown in the sample XML.",
        "comment" : "This value MAY contain zero or more [0..*] qualifier (CONF:1198-31870)."
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.entryRelationship:severity-entry",
        "path" : "Observation.entryRelationship",
        "sliceName" : "severity-entry",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-9059) such that it",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.entryRelationship:severity-entry.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Observation.entryRelationship:severity-entry.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1198-9069).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Observation.entryRelationship:severity-entry.observation",
        "path" : "Observation.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Severity.Entry"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:problem-status",
        "path" : "Observation.entryRelationship",
        "sliceName" : "problem-status",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.entryRelationship:problem-status.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31531).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship:problem-status.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "fixedBoolean" : false
      },
      {
        "id" : "Observation.entryRelationship:problem-status.observation",
        "path" : "Observation.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Problem.Status.Observation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:health-status",
        "path" : "Observation.entryRelationship",
        "sliceName" : "health-status",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.entryRelationship:health-status.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31532).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship:health-status.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "fixedBoolean" : false
      },
      {
        "id" : "Observation.entryRelationship:health-status.observation",
        "path" : "Observation.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Health.Status.Observation"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
