# IHE Medical Summary CDA - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE Medical Summary CDA**

## Logical Model: IHE Medical Summary CDA 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MS.CDA | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_MedicalSummary_CDA |

 
TBD 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.MS.CDA)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.MS.CDA.csv), [Excel](StructureDefinition-IHE.PCC.MS.CDA.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.MS.CDA",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MS.CDA",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_MedicalSummary_CDA",
  "title" : "IHE Medical Summary CDA",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "TBD",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MD.CDA",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.MS.CDA"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:medical-summary",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "medical-summary",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.templateId:medical-summary.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.1.2"
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-8349).",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:active-problems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "active-problems",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:active-problems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL Contain at least 1..* problem entries Otherwise a Null value SHALL be present",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Active.Problems.Section"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain at least 1 Allergry concernt entry otherwise a NUll Value SHALL be present.",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.AllergiesAndOtherAdverseReactions.Section"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "payers",
        "comment" : "This structuredBody MAY contain zero or one Payers Section",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:payers.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Section"
            ]
          }
        ]
      }
    ]
  }
}

```
