# IHE Active Problems Section - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE Active Problems Section**

## Logical Model: IHE Active Problems Section 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Active.Problems.Section | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_Active_Problems_Section |

 
The active problem section shall contain a narrative description of the conditions currently being monitored for the patient. It shall include entries for patient conditions as described in the Entry Content Module. 

**Usages:**

* Use this Logical Model Profile: [IHE Medical Summary CDA](StructureDefinition-IHE.PCC.MS.CDA.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.Active.Problems.Section)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.Active.Problems.Section.csv), [Excel](StructureDefinition-IHE.PCC.Active.Problems.Section.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.Active.Problems.Section",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Active.Problems.Section",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_Active_Problems_Section",
  "title" : "IHE Active Problems Section",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "The active problem section shall contain a narrative description of the conditions currently being monitored for the patient. It shall include entries for patient conditions as described in the Entry Content Module.\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "ihe-shall-problem-concern-act",
            "severity" : "error",
            "human" : "If section/@nullFlavor is not present, SHALL contain at least one Problem Concern Entry",
            "expression" : "nullFlavor.exists() or entry.where(act.hasTemplateIdOf('https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE_Problem_Concern_Entry')).exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Active.Problems.Section"
          }
        ]
      },
      {
        "id" : "Section.nullFlavor",
        "path" : "Section.nullFlavor",
        "short" : "If a required section contains no information, the @nullFlavor MAY be set to NI"
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Section.templateId:astm-parent",
        "path" : "Section.templateId",
        "sliceName" : "astm-parent",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Section.templateId:astm-parent.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.11",
        "mustSupport" : true
      },
      {
        "id" : "Section.templateId:activeProblemsSection",
        "path" : "Section.templateId",
        "sliceName" : "activeProblemsSection",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Section.templateId:activeProblemsSection.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : ".3.6.1.4.1.19376.1.5.3.1.3.6",
        "mustSupport" : true
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Problem list - Reported",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "11450-4",
        "mustSupport" : true
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1",
        "mustSupport" : true
      },
      {
        "id" : "Section.code.codeSystemName",
        "path" : "Section.code.codeSystemName",
        "patternString" : "LOINC"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "mustSupport" : true
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "mustSupport" : true
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "If section/@nullFlavor is not present:",
        "comment" : "SHALL contain at least one [1..*] entry (CONF:1198-9183)",
        "min" : 1
      },
      {
        "id" : "Section.entry:problem-Concern-Entry",
        "path" : "Section.entry",
        "sliceName" : "problem-Concern-Entry",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Section.entry:problem-Concern-Entry.act",
        "path" : "Section.entry.act",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Problem.Concern.Entry"
            ]
          }
        ]
      }
    ]
  }
}

```
