# IHE Probelm Concern Entry - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE Probelm Concern Entry**

## Logical Model: IHE Probelm Concern Entry 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Problem.Concern.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_Problem_Concern_Entry |

 
This entry is a specialization of the Concern Entry, wherein the subject of the concern is focused on a problem. 

**Usages:**

* Use this Logical Model Profile: [IHE Active Problems Section](StructureDefinition-IHE.PCC.Active.Problems.Section.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.Problem.Concern.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.Problem.Concern.Entry.csv), [Excel](StructureDefinition-IHE.Problem.Concern.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.Problem.Concern.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Problem.Concern.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_Problem_Concern_Entry",
  "title" : "IHE Probelm Concern Entry",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "This entry is a specialization of the Concern Entry, wherein the subject of the concern is focused on a problem.\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act.templateId:ihe-prob-concern-entry",
        "path" : "Act.templateId",
        "sliceName" : "ihe-prob-concern-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:ihe-prob-concern-entry.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.5.2"
      },
      {
        "id" : "Act.entryRelationship:problem-entry",
        "path" : "Act.entryRelationship",
        "sliceName" : "problem-entry",
        "min" : 1
      }
    ]
  }
}

```
