# IHE Concern Entry - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE Concern Entry**

## Logical Model: IHE Concern Entry 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_Concern_Entry |

 
This event (moodCode='EVN') represents an act (<act classCode='ACT') of being concerned about a problem, allergy or other issue. Theelement describes the period of concern. The subject of concern is one or more observations about related problems (see 1.3.6.1.4.1.19376.1.5.3.1.4.5.2) or allergies and intolerances (see 1.3.6.1.4.1.19376.1.5.3.1.4.5.3). Additional references can be provided having additional information related to the concern. The concern entry allows related acts to be grouped. This4415 allows representing the history of a problem as a series of observation over time, for example. 

**Usages:**

* Derived from this Logical Model Profile: [IHE Allergies and Intolerances Concern Entry](StructureDefinition-IHE.Allergies.And.Intolerances.Concern.Entry.md) and [IHE Probelm Concern Entry](StructureDefinition-IHE.Problem.Concern.Entry.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.Concern.Entry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.Concern.Entry.csv), [Excel](StructureDefinition-IHE.PCC.Concern.Entry.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.Concern.Entry",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_Concern_Entry",
  "title" : "IHE Concern Entry",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "This event (moodCode='EVN') represents an act (<act classCode='ACT') of being concerned about a problem, allergy or other issue. The <effectiveTime> element describes the period of concern. The subject of concern is one or more observations about related problems (see 1.3.6.1.4.1.19376.1.5.3.1.4.5.2) or allergies and intolerances (see 1.3.6.1.4.1.19376.1.5.3.1.4.5.3). Additional references can be provided having additional information related to the concern. The concern entry allows related acts to be grouped. This4415 allows representing the history of a problem as a series of observation over time, for example.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Act.templateId:problem",
        "path" : "Act.templateId",
        "sliceName" : "problem",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Act.templateId:problem.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.27"
      },
      {
        "id" : "Act.templateId:allergies-and-intolerances",
        "path" : "Act.templateId",
        "sliceName" : "allergies-and-intolerances",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Act.templateId:allergies-and-intolerances.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.6"
      },
      {
        "id" : "Act.templateId:ihe-concern-entry",
        "path" : "Act.templateId",
        "sliceName" : "ihe-concern-entry",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:ihe-concern-entry.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.4.5.1"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-9024).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-9025).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "MUST contain at least one [1..*] id (CONF:1198-9026).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-9027).",
        "mustSupport" : true
      },
      {
        "id" : "Act.code.nullFlavor",
        "path" : "Act.code.nullFlavor",
        "min" : 1,
        "patternCode" : "NA"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry"
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "short" : "The statusCode of the Concern Entry is the definitive indication of the status of the concern, whereas the effectiveTime of the nested Problem Observation is the definitive indication of whether or not the underlying condition is resolved.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.statusCode.nullFlavor",
        "path" : "Act.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1198-9030).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.effectiveTime.low",
        "path" : "Act.effectiveTime.low",
        "short" : "The effectiveTime/low of the Concern Entry asserts when the concern became active.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-9032).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.effectiveTime.high",
        "path" : "Act.effectiveTime.high",
        "short" : "The effectiveTime/high asserts when the concern was completed (e.g., when the clinician deemed there is no longer any need to track the underlying condition).",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:1198-9033).",
        "constraint" : [
          {
            "key" : "ihe-shall-time-high",
            "severity" : "error",
            "human" : "If statusCode is aborted or completed then effectiveTime.high Shall be present and shall not be present otherwise",
            "expression" : "(statusCode.code.exists(code=#aborted) or statusCode.code.exists(code=#completed) implies effectiveTime.high.exists() )",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Concern.Entry"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "The following entryRelationships represent identifying problems of concern and providing more information about the concern.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Act.entryRelationship:problem-entry",
        "path" : "Act.entryRelationship",
        "sliceName" : "problem-entry",
        "comment" : "SHALL contain exactly one [1..1] entryRelationship (CONF:1198-9034) such that it",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Act.entryRelationship:problem-entry.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-9035).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Act.entryRelationship:problem-entry.inversionInd",
        "path" : "Act.entryRelationship.inversionInd",
        "min" : 1,
        "fixedBoolean" : false
      },
      {
        "id" : "Act.entryRelationship:problem-entry.observation",
        "path" : "Act.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.Problem.Entry"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:allergies-and-ntolerances-entry",
        "path" : "Act.entryRelationship",
        "sliceName" : "allergies-and-ntolerances-entry",
        "comment" : "SHALL contain exactly one [1..1] entryRelationship (CONF:1198-9034) such that it",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Act.entryRelationship:allergies-and-ntolerances-entry.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-9035).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Act.entryRelationship:allergies-and-ntolerances-entry.inversionInd",
        "path" : "Act.entryRelationship.inversionInd",
        "min" : 1,
        "fixedBoolean" : false
      },
      {
        "id" : "Act.entryRelationship:allergies-and-ntolerances-entry.observation",
        "path" : "Act.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.Allergies.And.Intolerances.Entry"
            ]
          }
        ]
      }
    ]
  }
}

```
