# IHE Payers Section - Paramedicine Summary Of Care CDA v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE Payers Section**

## Logical Model: IHE Payers Section 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Section | *Version*:0.0.1-current |
| Draft as of 2025-11-04 | *Computable Name*:IHE_PCC_CDA_Payers_Section |

 
The Payers section contains data on the patient’s payers, whether a ‘third party’ insurance, self-pay, other payer or guarantor, or some combination. 

**Usages:**

* Use this Logical Model Profile: [IHE Medical Summary CDA](StructureDefinition-IHE.PCC.MS.CDA.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.pcc.pscc|current/StructureDefinition/IHE.PCC.CDA.Payers.Section)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCC.CDA.Payers.Section.csv), [Excel](StructureDefinition-IHE.PCC.CDA.Payers.Section.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "IHE.PCC.CDA.Payers.Section",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueUri" : "cda"
    }
  ],
  "url" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Section",
  "version" : "0.0.1-current",
  "name" : "IHE_PCC_CDA_Payers_Section",
  "title" : "IHE Payers Section",
  "status" : "draft",
  "date" : "2025-11-04T19:19:26+00:00",
  "publisher" : "IHE Patient Care Coordination Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/patient_care_coordination/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE Patient Care Coordination Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "pcc@ihe.net"
        }
      ]
    }
  ],
  "description" : "The Payers section contains data on the patient’s payers, whether a ‘third party’ insurance, self-pay, other payer or guarantor, or some combination.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "ihe-should-coverage-entry",
            "severity" : "warning",
            "human" : "If section/@nullFlavor is not present, SHOULD contain at least one Coverage Entry",
            "expression" : "nullFlavor.exists() or entry.where(act.hasTemplateIdOf('https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE_PCC_CDA_Coverage_Entry')).exists()",
            "source" : "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Payers.Section"
          }
        ]
      },
      {
        "id" : "Section.nullFlavor",
        "path" : "Section.nullFlavor",
        "short" : "If a required section contains no information, the @nullFlavor MAY be set to NI"
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Section.templateId:ccdPayment",
        "path" : "Section.templateId",
        "sliceName" : "ccdPayment",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Section.templateId:ccdPayment.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.1.9",
        "mustSupport" : true
      },
      {
        "id" : "Section.templateId:payersSection",
        "path" : "Section.templateId",
        "sliceName" : "payersSection",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Section.templateId:payersSection.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "1.3.6.1.4.1.19376.1.5.3.1.1.5.3.7",
        "mustSupport" : true
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Payment Sources",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "48768-6",
        "mustSupport" : true
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1",
        "mustSupport" : true
      },
      {
        "id" : "Section.code.codeSystemName",
        "path" : "Section.code.codeSystemName",
        "patternString" : "LOINC"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "mustSupport" : true
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "mustSupport" : true
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "If section/@nullFlavor is not present:",
        "comment" : "SHALL contain at least one [1..*] entry (CONF:1198-9183)"
      },
      {
        "id" : "Section.entry:coverage-Entry",
        "path" : "Section.entry",
        "sliceName" : "coverage-Entry",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Section.entry:coverage-Entry.act",
        "path" : "Section.entry.act",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "https://profiles.ihe.net/PCC/PSCc/StructureDefinition/IHE.PCC.CDA.Coverage.Entry"
            ]
          }
        ]
      }
    ]
  }
}

```
