# Example ips Patient Jannet Guo - FHIR International Patient Summary v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example ips Patient Jannet Guo**

## Example Patient: Example ips Patient Jannet Guo

Profile: [Patient (IPS)](http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

Jannet Xiaodongni Guo(official) Female, DoB: 1993-07-25 ( Medical Record Number: fcf76d34-1a29-4d51-a119-991dc5aac192)

-------

| | |
| :--- | :--- |
| Marital Status: | Never Married |
| Other Ids: | * Driver's License/S99970944
* Passport Number/X4940908X
 |
| Contact Detail | * ph: (262) 245-9214(Home)
* ph: (407) 722-4000(Work)
* [GuoJX@example.com](mailto:GuoJX@example.com)
* 18 S Walworth Ave Williams Bay Wisconsin 53191 USA (home)
 |
| Language: | English(preferred) |
| Next-of-Kin: | * Yijun Guo(Official) (Male)
* 306 Carson St Chippewa Falls Wisconsin 54729 US 
* ph: (715) 726-1227(Mobile)
 |
| Links: | * General Practitioner: [Practitioner/ex-ips-practitioner-alicia-gould](Practitioner/ex-ips-practitioner-alicia-gould)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "02d72bc1-54a1-4751-83a3-658afc3f2bff",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips"
    ],
    "security" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HTEST"
      }
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://hospital.smarthealthit.org",
      "value" : "fcf76d34-1a29-4d51-a119-991dc5aac192"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "DL",
            "display" : "Driver's License"
          }
        ],
        "text" : "Driver's License"
      },
      "system" : "urn:oid:2.16.840.1.113883.4.3.25",
      "value" : "S99970944"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN",
            "display" : "Passport Number"
          }
        ],
        "text" : "Passport Number"
      },
      "system" : "http://standardhealthrecord.org/fhir/StructureDefinition/passportNumber",
      "value" : "X4940908X"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "text" : "Jannet Xiaodongni Guo",
      "family" : "Guo",
      "given" : ["Jannet"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(262) 245-9214",
      "use" : "home"
    },
    {
      "system" : "phone",
      "value" : "(407) 722-4000",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "GuoJX@example.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "1993-07-25",
  "address" : [
    {
      "use" : "home",
      "line" : ["18 S Walworth Ave"],
      "city" : "Williams Bay",
      "state" : "Wisconsin",
      "postalCode" : "53191",
      "country" : "USA"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
        "code" : "S",
        "display" : "Never Married"
      }
    ],
    "text" : "Never Married"
  },
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N"
            }
          ]
        }
      ],
      "name" : {
        "use" : "official",
        "text" : "Yijun Guo",
        "family" : "Guo",
        "given" : ["Yijun"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "(715) 726-1227",
          "use" : "mobile"
        }
      ],
      "address" : {
        "line" : ["306 Carson St"],
        "city" : "Chippewa Falls",
        "state" : "Wisconsin",
        "postalCode" : "54729",
        "country" : "US"
      },
      "gender" : "male"
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en-US",
            "display" : "English"
          }
        ],
        "text" : "English"
      },
      "preferred" : true
    }
  ],
  "generalPractitioner" : [
    {
      "reference" : "Practitioner/ex-ips-practitioner-alicia-gould"
    }
  ]
}

```
