# Test Plan - FHIR International Patient Summary v0.0.1-current

* [**Table of Contents**](toc.md)
* **Test Plan**

## Test Plan

This Test Plan page is a prototype. We expect the maturity of the content will improve over time. For now, we summarize high level testing scope and available tools. Comments are welcome. These are the summaries of the expectations of the test scripts that will be developed for the IPS Test Plans.

The following test plans are generated for the content testing of the IPS. The testing events encourages testing paired with a transport. For education on what transports can be used for IPS documents please refer to the [HIE Whitepaper](https://profiles.ihe.net/ITI/HIE-Whitepaper/)

The goals of testing the IPS are:

* Test that the document generated by the Content Creator system is conformant to HL7's IPS FHIR document and any additional implementation options chosen for the test.
* Test that the Content Consumer system is able to consume the IPS document and implementaiton option in one of the accepted formats: View, Document Import, Section Import, or Descreet Data import. These options are chosen by the Content Consumer system at registration.

## Testing Expectations

### Obligations and Data Absent Reasons

For all **Requiried if Known** Sections or Elements there will be a testing requirment to express missing data due to being unavailable to the product rather than asserting it is not relivant by ommision.

If there is no relivant information provided for a Must support/Required if Known section or element the section MAY be ommitted and No Data ABsent/Empty Reson will be expected.

If the system does not have access to data to populate a Must Support/Required if Known Section or Data Element it SHALL contain an data absent/Empty Reason indicating why the information is unavailable. This is a patient Safety requirement to identify that the information cannot be assumed empty or irrelivant. This can be achived using the Unavailable code for an [Empty Reason](http://terminology.hl7.org/CodeSystem/list-empty-reason) at the Section level or a [Data Absent Reason](https://hl7.org/fhir/R5/valueset-data-absent-reason.html) at the Entry level. This Distinguishes between an intentional ommision of data determined my a mediator to not be relivant.

**Handeling** There are many elements within this profile that have the Handeling Obligation for the Content Consumer system. During Testing the Content Consumer system will undergo visual inspection to review that the handeling expectation is achieved.

* for systems that support the element that element will be imported
* for systems that do not support the import or storage of the section or element with the handeling requirement there SHALL be an ability to highlight to the user displayable information or highlights to the user that the data is missing and therfore unknown.

Proof of handeling can be done through the following Content Comsumer Options

* Document Import
* Section Import (Not applicable for entry level Handeling requirments)
* Descreet Data Import (TBD review onthis)

### Test Patient Data

Systems will be provided with a predeterminded set of data expectations that SHALL be met before arriving at the testing event.

A number of patients for the testing options will be provided with the expected information that SHALL be generated into the patient record with the Content Creator system.

The patient information will range from a complex patient record to a similistic one to properly test the implementation of the Manditory and Reccomented sections.

Sample Patient Records may be provided if the testing system would rather import predetermined patient information.

## Introduction

Overall test plan leverages the Profiles, and Examples shown on the [Artifacts Summary](artifacts.md). The [Profiles](artifacts.md#structures-resource-profiles) listed are describing the constraints that would be adhered to by Actors claiming conformance to this implementation guide. Thus any applicable Resources that are known to have been published by an app or server MUST be conformant to these profiles as appropriate.

The Examples listed in [Example Instances](artifacts.md#example-example-instances) are example instances. Some are conformant to the profiles. Other examples that either assist with the structure of the examples (e.g. Patient and Encounter) or are examples that should be able to handle in various ways.

### Content Creator Add Patient Records Test

1. The system under test will be required to document which data elements from the must support and required concepts can be collected and maintained within the product. This information will be used to verify expectations for missing content that will be examined in the resulting IPS Document. The Monitor will verify that this documentation is provided. a. For the Occupational Data for Health Option
 i. The system under test will be required to document which data elements supporting the Occupational Data for Health Option concepts can be collected and maintained within the product. b. For the Complete Option i. The system under test will be required to document which data elements supporting the Complete Option can be collected and maintained within the product.
1. Data will be provided for all required sections and data elements such that the system under test will be able to demonstrate inclusion of these concepts within the IPS document generated in the subsequent tests. Screenshots should be provided to show that the data has been added to the patient's record within the system. a. For the Occupational Data for Health Option
 i. Data will be provided for all data elements supporting the Occupational Data for Health Option. b. For the Complete Option i. Data will be provided for all data elements supporting the Complete Option.
1. This is a No Peer Test.

### Content Creator Document Check Test

1. The Content Creator system will generate an IPS for the patient(s) provided in the Add Patient Records Test that includes all must support and required concepts. This IPS will be validated using the IHE External Validation Tool.
1. The Montor will visually inspect to verify that all must support and required concepts documented in the Add Patient Records Test as collected and maintained within the product are included the validated IPS.
1. This is a no Peer Test.

### Content Creator ImportExport Test

1. The monitor verifies that a validated IPS document is successfully generated by the Content Creator.
1. The Monitor verifies that the Content Consumer is able to consume the document provided by the Content Creator using at least one of the Content Consumer options (View, Document Import, Section Import, Discrete Data Import).
1. No transport is required for this test.
1. This is a peer to peer test between a Content Creator and Content Consumer.

