# FHIR International Patient Summary Profile Home - FHIR International Patient Summary v0.0.1-current

* [**Table of Contents**](toc.md)
* **FHIR International Patient Summary Profile Home**

## FHIR International Patient Summary Profile Home

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/PCC/FIIO/ImplementationGuide/ihe.pcc.fiio | *Version*:0.0.1-current |
| Draft as of 2026-02-06 | *Computable Name*:IHE_PCC_FIIO |

**This IPS profile uses the Health Level 7's FHIR International Patient Summary (IPS) that realizes the CEN EN 17269 IPS dataset to profile additional implementation options that can be incorporated into the IPS document. This is a Content Module profile that defines these additional Implementation options.**

| |
| :--- |
| [Significant Changes, Open and Closed Issues](issues.md) |

### Organization of This Guide

This guide is organized into the following sections:

1. Volume 1:
1. [Introduction](volume-1.md)
1. [Actors, Transactions, and Content](volume-1.md#actors-and-transactions)
1. [Actor Options](volume-1.md#actor-options)
1. [Actor Required Groupings](volume-1.md#required-groupings)
1. [Overview](volume-1.md#overview)
1. [Security Considerations](volume-1.md#security-considerations)
1. [Cross Profile Considerations](volume-1.md#other-grouping)

1. Volume 3: Metadata and Content
1. [FHIR Content Modules](volume-3.md.md)

1. Other
1. [Test Plan](testplan.md)
1. [Changes to Other IHE Specifications](other.md)
1. [Download and Analysis](download.md)

See also the [Table of Contents](toc.md) and the index of [Artifacts](artifacts.md) defined as part of this implementation guide.

### Conformance Expectations

IHE uses the normative words: Shall, Should, and May according to [standards conventions](https://profiles.ihe.net/GeneralIntro/ch-E.html).

#### Must Support

The use of `mustSupport` in StructureDefinition profiles equivalent to the IHE use of **R2** as defined in [Appendix Z](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.10-profiling-conventions-for-constraints-on-fhir).

mustSupport of true - only has a meaning on items that are minimal cardinality of zero (0), and applies only to the source actor populating the data. The source actor shall populate the elements marked with MustSupport, if the concept is supported by the actor, a value exists, and security and consent rules permit. The consuming actors should handle these elements being populated or being absent/empty. Note that sometimes mustSupport will appear on elements with a minimal cardinality greater than zero (0), this is due to inheritance from a less constrained profile.

