# Download and Analysis - FHIR International Patient Summary v0.0.1-current

* [**Table of Contents**](toc.md)
* **Download and Analysis**

## Download and Analysis

You can also download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), or [ttl](definitions.ttl.zip)
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on th [IHE PCC GitHub](https://github.com/IHE/PCC.FIIO)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (ihe.pcc.fiio.r4)](package.r4.tgz) and [R4B (ihe.pcc.fiio.r4b)](package.r4b.tgz) are available.

#### Dependency Table











#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md), [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md), [Composition/2a7a5f03-9581-4677-ba18-fbd3b221f601](Composition-2a7a5f03-9581-4677-ba18-fbd3b221f601.md), [IHE_FIPS_IO_Complete_Option_Composition](StructureDefinition-IHE.FIPS.IO.Complete.Option.Composition.md) and [IHE_FIPS_IO_ODH_Option_Composition](StructureDefinition-IHE.FIPS.IO.ODH.Option.Composition.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [Condition Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-category.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.1/CodeSystem-condition-ver-status.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [DataAbsentReason](http://terminology.hl7.org/7.0.1/CodeSystem-data-absent-reason.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Composition/2a7a5f03-9581-4677-ba18-fbd3b221f601](Composition-2a7a5f03-9581-4677-ba18-fbd3b221f601.md)
* [DoseAndRateType](http://terminology.hl7.org/7.0.1/CodeSystem-dose-rate-type.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md)
* [Flag Category](http://terminology.hl7.org/7.0.1/CodeSystem-flag-category.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [Organization type](http://terminology.hl7.org/7.0.1/CodeSystem-organization-type.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md)
* [contactRole2](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0131.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Patient/02d72bc1-54a1-4751-83a3-658afc3f2bff](Patient-02d72bc1-54a1-4751-83a3-658afc3f2bff.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Patient/02d72bc1-54a1-4751-83a3-658afc3f2bff](Patient-02d72bc1-54a1-4751-83a3-658afc3f2bff.md)
* [degreeLicenseCertificate](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0360.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md)
* [providerRole](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0443.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [ActClass](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActClass.html): [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md), [IHE_FIPS_IO_Complete_Option_Composition](StructureDefinition-IHE.FIPS.IO.Complete.Option.Composition.md) and [IHE_FIPS_IO_ODH_Option_Composition](StructureDefinition-IHE.FIPS.IO.ODH.Option.Composition.md)
* [ActReason](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html): [Patient/02d72bc1-54a1-4751-83a3-658afc3f2bff](Patient-02d72bc1-54a1-4751-83a3-658afc3f2bff.md)
* [ActSite](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActSite.html): [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v3-MaritalStatus.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md) and [Patient/02d72bc1-54a1-4751-83a3-658afc3f2bff](Patient-02d72bc1-54a1-4751-83a3-658afc3f2bff.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)
* [ObservationValue](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationValue.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [Bundle/e0e8252a-4aab-4fab-ac8f-5734abbd1ec7](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md)
* [RouteOfAdministration](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RouteOfAdministration.html): [Bundle/ex-bundle-secondaryUse-pandemnicips-patricia-jordana](Bundle-ex-bundle-secondaryUse-pandemnicips-patricia-jordana.md)


