# Patient Summary of Genny Works - FHIR International Patient Summary v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Summary of Genny Works**

## Example Composition: Patient Summary of Genny Works

Last updated: 2026-02-05 13:51:24+0200

Profiles: [International Patient Summary Occupational Data For Health Implementation Option Composition](StructureDefinition-IHE.FIPS.IO.ODH.Option.Composition.md), [FHIR International Patient Summary Implementation Options - Complete Option Composition](StructureDefinition-IHE.FIPS.IO.Complete.Option.Composition.md)

**status**: Final

**type**: Patient summary Document

**date**: 2026-02-05 12:13:00+0200

**author**: [Organization IHE International PCC](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md#urn-uuid-8353925b-4e3e-4885-8330-01600699e428)

**title**: Patient Summary of Genny Works

**confidentiality**: normal

**custodian**: [Organization IHE International PCC](Bundle-e0e8252a-4aab-4fab-ac8f-5734abbd1ec7.md#urn-uuid-8353925b-4e3e-4885-8330-01600699e428)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "2a7a5f03-9581-4677-ba18-fbd3b221f601",
  "meta" : {
    "lastUpdated" : "2026-02-05T13:51:24+02:00",
    "profile" : [
      "https://profiles.ihe.net/PCC/FIIO/StructureDefinition/IHE.FIPS.IO.ODH.Option.Composition",
      "https://profiles.ihe.net/PCC/FIIO/StructureDefinition/IHE.FIPS.IO.Complete.Option.Composition"
    ]
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "60591-5",
        "display" : "Patient summary Document"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fb45133f-447a-49e8-ba3d-71fbcc7fdcc1"
  },
  "date" : "2026-02-05T12:13:00+02:00",
  "author" : [
    {
      "reference" : "urn:uuid:8353925b-4e3e-4885-8330-01600699e428"
    }
  ],
  "title" : "Patient Summary of Genny Works",
  "confidentiality" : "N",
  "custodian" : {
    "reference" : "urn:uuid:8353925b-4e3e-4885-8330-01600699e428"
  },
  "section" : [
    {
      "title" : "Problem List",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "11450-4",
            "display" : "Problem list - Reported"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>[2007-04-27] - Attention deficit hyperactivity disorder</li><li>[2012-07-16] - Substance abuse</li><li>[2017-04-26] - Tonsillitis</li><li>[2007-01-26] - Decreased hearing</li></ul></div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:dbd46d98-d6fd-42a1-ba51-7394325f15cf",
          "display" : "[2007-01-26] - Decreased hearing"
        }
      ]
    },
    {
      "title" : "Allergies and Intolerances",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48765-2",
            "display" : "Allergies and adverse reactions Document"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">No known allergies</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:515d5611-074b-4c13-aabe-5fcb87bbc481",
          "display" : "No known allergies"
        }
      ]
    },
    {
      "title" : "Medication List",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "10160-0",
            "display" : "History of Medication use Narrative"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>[2018] - Methylphenidate 5mg chewable tablet - 2 tablets per day</li><li>[2018] - Diazepam product</li></ul></div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:66feac59-356f-410b-9344-d3a9b4fed5d7",
          "display" : "[2018] - Diazepam product"
        }
      ]
    },
    {
      "title" : "History of Immunizations",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "11369-6",
            "display" : "History of Immunization note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div><ul><li>[2013-02-09] - Diphtheria + tetanus + poliomyelitis vaccine</li><li>[2013-07-08] - Hepatitis B virus vaccine</li><li>[2025-10-17] - COVID-19 antigen vaccine</li></ul></div></div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:3ec71eb2-ec74-4f91-993b-4c50453ee86d",
          "display" : "COVID-19 antigen vaccine"
        }
      ]
    },
    {
      "title" : "History of Procedures",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "47519-4",
            "display" : "History of Procedures Document"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">substance use therapy</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:e72697f5-2323-4ea3-8d70-af2363800ae4",
          "display" : "substance use therapy"
        }
      ]
    },
    {
      "title" : "Social History",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "29762-2",
            "display" : "Social history note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Social History</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:ac090ad2-2be4-4324-9018-ea85de87ba6a"
        },
        {
          "reference" : "urn:uuid:6c08db33-8f5f-487e-98fb-1e933c046bbe"
        },
        {
          "reference" : "urn:uuid:1541d2fd-2aee-40cd-8ced-162d2a0f92d3"
        },
        {
          "reference" : "urn:uuid:fb1a62be-9831-40c9-862f-48fd12faa913"
        },
        {
          "reference" : "urn:uuid:92ae1223-5a0f-4e0c-a835-91f943aa4e1d"
        },
        {
          "reference" : "urn:uuid:f2a5add3-95ff-4ceb-ad60-b31d61d8471c"
        },
        {
          "reference" : "urn:uuid:5f710c84-728a-4024-bf62-70d2798e992c"
        }
      ]
    },
    {
      "title" : "Pregnancy History",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "10162-6",
            "display" : "History of Pregnancies Narrative"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Not Pregnant</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:af46b53c-6a51-4ec0-a1e5-e0eb4587b0f9",
          "display" : "Not Pregnant"
        }
      ]
    },
    {
      "title" : "Functional Status",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "47420-5",
            "display" : "Functional status assessment note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">[2007-01-26] - Decreased hearing</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:dbd46d98-d6fd-42a1-ba51-7394325f15cf",
          "display" : "[2007-01-26] - Decreased hearing"
        },
        {
          "reference" : "urn:uuid:b2d1d43f-cc18-42ff-9129-42c4d99bae8f"
        }
      ]
    },
    {
      "title" : "Alerts",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "104605-1",
            "display" : "Alert"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Misuse of medication</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:99c6a7f2-0661-4d22-955f-431314ecf2ce",
          "display" : "Misuse of medication"
        }
      ]
    },
    {
      "title" : "Diagnostic Results",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "30954-2",
            "display" : "Relevant diagnostic tests/laboratory data note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Results section</div>"
      },
      "emptyReason" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "not-applicable",
            "display" : "Not Applicable"
          }
        ]
      }
    },
    {
      "title" : "Medical Devices",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "46264-8",
            "display" : "History of Medical Device Use"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">No known device use</div>"
      },
      "entry" : [
        {
          "reference" : "urn:uuid:2ba7ec69-c597-41ec-837c-5295b95452fd",
          "display" : "No known device use"
        }
      ]
    },
    {
      "title" : "Advance Directives",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "42348-3",
            "display" : "Advance healthcare directives"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">No Advanced Directives</div>"
      }
    }
  ]
}

```
