# Table of Contents - Privacy Consent on FHIR (PCF) v1.1.1-current

* **Table of Contents**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

## Table of Contents

| |
| :--- |
| [0 Table of Contents](toc.md) |
| [1 Privacy Consent on FHIR (PCF) Home](index.md) |
| [2 1:53 Privacy Consent on FHIR](volume-1.md) |
| [3 1:Appendix P: Privacy Access Policies (Informative)](ch-P.md) |
| [4 2:3.108 Access Consent [ITI-108]](ITI-108.md) |
| [5 3:5.8 Privacy Consent Patterns](content.md) |
| [6 Changes to Other IHE Specifications](other.md) |
| [7 Download and Analysis](download.md) |
| [8 Test Plan](testplan.md) |
| [9 Significant Changes & Issues](issues.md) |
| [10 Artifacts Summary](artifacts.md) |
| [10.1 Basic Purpose ValueSet](ValueSet-BasicPurposeVS.md) |
| [10.2 Binary example using Binary](Binary-B-ink.md) |
| [10.3 Binary example using DocumentReference](DocumentReference-ex-consent-ink.md) |
| [10.4 Clerk Practitioner example](Practitioner-ex-clerk.md) |
| [10.5 Consent for access for treatment example given by mother to infants data](Consent-ex-consent-basic-treat-infant.md) |
| [10.6 Consent for any Healthcare Research example](Consent-ex-consent-basic-research.md) |
| [10.7 Consent for purpose of treatment example](Consent-ex-consent-basic-treat.md) |
| [10.8 Consent for treatment example with expiration](Consent-ex-consent-expired-treat.md) |
| [10.9 Consent for treatment example with ink signature](Consent-ex-consent-basic-ink.md) |
| [10.10 Dissent for treatment example](Consent-ex-consent-basic-reject.md) |
| [10.11 DocumentReference Consent Paperwork example](DocumentReference-ex-documentreference.md) |
| [10.12 Example Organization holding the data](Organization-ex-organization.md) |
| [10.13 Example Patient](Patient-ex-patient.md) |
| [10.14 IHE PCF Explicit Basic Consent](StructureDefinition-IHE.PCF.consentBasic.md) |
| [10.15 Provenance of Create of a basic consent](Provenance-ex-provenance-consent-basic-treat.md) |
| [10.16 Provenance of Update of a basic consent](Provenance-ex-provenance2-consent-basic-treat.md) |
| [10.17 Consent allowing data access for a given intermediate purpose](Consent-ex-consent-intermediate-purpose.md) |
| [10.18 Consent allowing data authored by a practitioner](Consent-ex-consent-intermediate-authoredby.md) |
| [10.19 Consent allowing data authored related to an encounter](Consent-ex-consent-intermediate-encounter.md) |
| [10.20 Consent allowing data authored within a timeframe](Consent-ex-consent-intermediate-timeframe.md) |
| [10.21 Consent allowing most sharing but NOT data authored by a practitioner](Consent-ex-consent-intermediate-not-authoredby.md) |
| [10.22 Consent allowing most sharing but NOT data authored within a timeframe](Consent-ex-consent-intermediate-not-timeframe.md) |
| [10.23 Consent allowing most sharing but NOT data related to an encounter](Consent-ex-consent-intermediate-not-encounter.md) |
| [10.24 Consent allowing most sharing but NOT specific data](Consent-ex-consent-intermediate-not-data.md) |
| [10.25 Consent allowing specific data](Consent-ex-consent-intermediate-data.md) |
| [10.26 Consent forbid data access except for Break-Glass](Consent-ex-dissent-intermediate-break-glass.md) |
| [10.27 Dummy Practitioner example](Practitioner-ex-practitioner.md) |
| [10.28 Example Encounter](Encounter-ex-encounter.md) |
| [10.29 Example Organization doing the FooBar Research](Organization-ex-org-researcher.md) |
| [10.30 IHE PCF Explicit Intermediate Consent](StructureDefinition-IHE.PCF.consentIntermediate.md) |
| [10.31 Those users that the organization authorizes to use Break-Glass](Group-ex-privilegedUsers.md) |
| [10.32 Advanced Security Tag ValueSet](ValueSet-AdvancedSecurityTagVS.md) |
| [10.33 Consent allowing NORMAL and break-glass access to RESTRICTED data](Consent-ex-consent-advanced-normal-break-glass-restricted.md) |
| [10.34 Consent allowing NORMAL and focused access to Mental Health or Sexual Health data](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md) |
| [10.35 Consent allowing NORMAL and focused Mental Health data access](Consent-ex-consent-advanced-normal-focused-psy.md) |
| [10.36 Consent allowing NORMAL and focused RESTRICTED data access](Consent-ex-consent-advanced-normal-focused-restricted.md) |
| [10.37 Consent allowing NORMAL and RESTRICTED data access](Consent-ex-consent-advanced-normal-restricted.md) |
| [10.38 Consent allowing NORMAL but not RESTRICTED data access](Consent-ex-consent-advanced-normal-not-restricted.md) |
| [10.39 Consent allowing NORMAL data access](Consent-ex-consent-advanced-normal.md) |
| [10.40 IHE PCF Explicit Advanced Consent](StructureDefinition-IHE.PCF.consentAdvanced.md) |
| [10.41 clinical codes that indicate ETH](ValueSet-SlsSensitiveETH.md) |
| [10.42 clinical codes that indicate ETHUD](ValueSet-SlsSensitiveETHUD.md) |
| [10.43 clinical codes that indicate HIV](ValueSet-SlsSensitiveHIV.md) |
| [10.44 clinical codes that indicate OPIOIDUD](ValueSet-SlsSensitiveOPIOIDUD.md) |
| [10.45 clinical codes that indicate PSY](ValueSet-SlsSensitivePSY.md) |
| [10.46 clinical codes that indicate SDV](ValueSet-SlsSensitiveSDV.md) |
| [10.47 Example of a blood pressure R4 observation, minimal](Observation-ex-bloodPressure.md) |
| [10.48 Example of a bodyWeight R4 observation](Observation-ex-weight.md) |
| [10.49 Example of an MHV blood sugar R4 observation](Observation-ex-bloodSugar.md) |
| [10.50 Example of an valid FHIR bodyWeight R4 observation, but not compliant with the profile](Observation-ex-weight-2.md) |
| [10.51 Observation - SH: Alcohol Use](Observation-ex-alcoholUse.md) |
| [10.52 PCF Consent Authorization Server Actor](CapabilityStatement-IHE.PCF.consentAuthorizationServer.md) |
| [10.53 PCF Consent Recorder Actor](CapabilityStatement-IHE.PCF.consentRecorder.md) |
| [10.54 PCF Consent Registry Actor](CapabilityStatement-IHE.PCF.consentRegistry.md) |
| [10.55 Dummy Authoring Practitioner example](Practitioner-ex-author.md) |
| [10.56 Mother of John](Patient-ex-mother.md) |

| | | |
| :--- | :--- | :--- |
|  <prev | [top](#top) |  [next>](index.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

