# Privacy Consent on FHIR (PCF) Home - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* **Privacy Consent on FHIR (PCF) Home**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

## Privacy Consent on FHIR (PCF) Home

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/ImplementationGuide/ihe.iti.pcf | *Version*:1.1.1-current |
| Active as of 2025-10-07 | *Computable Name*:IHE_ITI_PCF |

* [Organization of This Guide](#organization-of-this-guide)
* [Conformance Expectations](#conformance-expectations)

The Privacy Consent on FHIR (PCF) Profile provides support for patient privacy consents and access control where a FHIR API is used to access Document Sharing Health Information Exchanges.

This includes refinement of the consent handling defined in [MHDS](https://profiles.ihe.net/ITI/MHDS). The scope does not intend to cover all consent use cases, such as the consent use cases for within an organization, or more advanced consents that may be addressed in future versions of PCF.

| |
| :--- |
| [Significant Changes, Open and Closed Issues](issues.md) |

### Organization of This Guide

This guide is organized into the following sections:

* Volume 1: Profiles 
* [Introduction](volume-1.md)
* [Actors, Transactions, and Content](volume-1.md#actors-and-transactions)
* [Actor Options](volume-1.md#actor-options)
* [Actor Required Groupings](volume-1.md#required-groupings)
* [Overview](volume-1.md#overview)
* [Security Considerations](volume-1.md#security-considerations)
* [Cross Profile Considerations](volume-1.md#other-grouping)
* [Appendix P: Privacy Access Policies](ch-P.md)
 
* Volume 2: Transaction Detail 
* [Get Access Token [ITI-71]](other.md#updates-to-iti-71)
* [Incorporate Access Token [ITI-72]](https://profiles.ihe.net/ITI/IUA/index.html#372-incorporate-access-token-iti-72)
* [Introspect Token [ITI-102]](https://profiles.ihe.net/ITI/IUA/index.html#3102-introspect-token-iti-102)
* [Get Authorization Server Metadata [ITI-103]](https://profiles.ihe.net/ITI/IUA/index.html#3103-get-authorization-server-metadata-iti-103)
* [Access Consent [ITI-108]](ITI-108.md)
 
* Volume 3: Metadata and Content 
* [Privacy Consent Patterns](content.md)
 
* Other 
* [Changes to Other IHE Specification](other.md)
* [Updates to ITI-71](other.md#updates-to-iti-71)
* [Test Plan](testplan.md)
* [Download and Analysis](download.md)
 

See also the [Table of Contents](toc.md) and the index of [Artifacts](artifacts.md) defined as part of this implementation guide.

### Conformance Expectations

IHE uses the normative words: Shall, Should, and May according to [standards conventions](https://profiles.ihe.net/GeneralIntro/ch-E.html).

#### Must Support

The use of `mustSupport` in StructureDefinition profiles equivalent to the IHE use of **R2** as defined in [Appendix Z](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.10-profiling-conventions-for-constraints-on-fhir).

mustSupport of true - only has a meaning on items that are minimal cardinality of zero (0), and applies only to the source actor populating the data. The source actor shall populate the elements marked with MustSupport, if the concept is supported by the actor, a value exists, and security and consent rules permit. The consuming actors should handle these elements being populated or being absent/empty. Note that sometimes mustSupport will appear on elements with a minimal cardinality greater than zero (0), this is due to inheritance from a less constrained profile.

| | | |
| :--- | :--- | :--- |
|  [<prev](toc.md) | [top](#top) |  [next>](volume-1.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

