# Download and Analysis - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* **Download and Analysis**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

## Download and Analysis

You can download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [IHE ITI.PCF Github Repo](https://github.com/IHE/ITI.PCF).

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B} systems. Packages for both [R4 (ihe.iti.pcf.r4)](package.r4.tgz) and [R4B (ihe.iti.pcf.r4b)](package.r4b.tgz) are available.

#### Dependency Table





#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Observation/ex-alcoholUse](Observation-ex-alcoholUse.md), [Observation/ex-bloodPressure](Observation-ex-bloodPressure.md), [Observation/ex-bloodSugar](Observation-ex-bloodSugar.md), [Observation/ex-weight](Observation-ex-weight.md) and [Observation/ex-weight-2](Observation-ex-weight-2.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Consent/ex-consent-advanced-normal](Consent-ex-consent-advanced-normal.md), [Consent/ex-consent-advanced-normal-break-glass-restricted](Consent-ex-consent-advanced-normal-break-glass-restricted.md)...Show 27 more,[Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md),[Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md),[Consent/ex-consent-advanced-normal-focused-restricted](Consent-ex-consent-advanced-normal-focused-restricted.md),[Consent/ex-consent-advanced-normal-not-restricted](Consent-ex-consent-advanced-normal-not-restricted.md),[Consent/ex-consent-advanced-normal-restricted](Consent-ex-consent-advanced-normal-restricted.md),[Consent/ex-consent-basic-ink](Consent-ex-consent-basic-ink.md),[Consent/ex-consent-basic-reject](Consent-ex-consent-basic-reject.md),[Consent/ex-consent-basic-research](Consent-ex-consent-basic-research.md),[Consent/ex-consent-basic-treat](Consent-ex-consent-basic-treat.md),[Consent/ex-consent-basic-treat-infant](Consent-ex-consent-basic-treat-infant.md),[Consent/ex-consent-expired-treat](Consent-ex-consent-expired-treat.md),[Consent/ex-consent-intermediate-authoredby](Consent-ex-consent-intermediate-authoredby.md),[Consent/ex-consent-intermediate-data](Consent-ex-consent-intermediate-data.md),[Consent/ex-consent-intermediate-encounter](Consent-ex-consent-intermediate-encounter.md),[Consent/ex-consent-intermediate-not-authoredby](Consent-ex-consent-intermediate-not-authoredby.md),[Consent/ex-consent-intermediate-not-data](Consent-ex-consent-intermediate-not-data.md),[Consent/ex-consent-intermediate-not-encounter](Consent-ex-consent-intermediate-not-encounter.md),[Consent/ex-consent-intermediate-not-timeframe](Consent-ex-consent-intermediate-not-timeframe.md),[Consent/ex-consent-intermediate-purpose](Consent-ex-consent-intermediate-purpose.md),[Consent/ex-consent-intermediate-timeframe](Consent-ex-consent-intermediate-timeframe.md),[Consent/ex-dissent-intermediate-break-glass](Consent-ex-dissent-intermediate-break-glass.md),[DocumentReference/ex-documentreference](DocumentReference-ex-documentreference.md),[Observation/ex-alcoholUse](Observation-ex-alcoholUse.md),[Observation/ex-bloodPressure](Observation-ex-bloodPressure.md),[Observation/ex-bloodSugar](Observation-ex-bloodSugar.md),[Observation/ex-weight](Observation-ex-weight.md)and[Observation/ex-weight-2](Observation-ex-weight-2.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Consent Scope Codes](http://terminology.hl7.org/6.5.0/CodeSystem-consentscope.html): [AdvancedConsent](StructureDefinition-IHE.PCF.consentAdvanced.md), [BasicConsent](StructureDefinition-IHE.PCF.consentBasic.md)...Show 24 more,[Consent/ex-consent-advanced-normal](Consent-ex-consent-advanced-normal.md),[Consent/ex-consent-advanced-normal-break-glass-restricted](Consent-ex-consent-advanced-normal-break-glass-restricted.md),[Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md),[Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md),[Consent/ex-consent-advanced-normal-focused-restricted](Consent-ex-consent-advanced-normal-focused-restricted.md),[Consent/ex-consent-advanced-normal-not-restricted](Consent-ex-consent-advanced-normal-not-restricted.md),[Consent/ex-consent-advanced-normal-restricted](Consent-ex-consent-advanced-normal-restricted.md),[Consent/ex-consent-basic-ink](Consent-ex-consent-basic-ink.md),[Consent/ex-consent-basic-reject](Consent-ex-consent-basic-reject.md),[Consent/ex-consent-basic-research](Consent-ex-consent-basic-research.md),[Consent/ex-consent-basic-treat](Consent-ex-consent-basic-treat.md),[Consent/ex-consent-basic-treat-infant](Consent-ex-consent-basic-treat-infant.md),[Consent/ex-consent-expired-treat](Consent-ex-consent-expired-treat.md),[Consent/ex-consent-intermediate-authoredby](Consent-ex-consent-intermediate-authoredby.md),[Consent/ex-consent-intermediate-data](Consent-ex-consent-intermediate-data.md),[Consent/ex-consent-intermediate-encounter](Consent-ex-consent-intermediate-encounter.md),[Consent/ex-consent-intermediate-not-authoredby](Consent-ex-consent-intermediate-not-authoredby.md),[Consent/ex-consent-intermediate-not-data](Consent-ex-consent-intermediate-not-data.md),[Consent/ex-consent-intermediate-not-encounter](Consent-ex-consent-intermediate-not-encounter.md),[Consent/ex-consent-intermediate-not-timeframe](Consent-ex-consent-intermediate-not-timeframe.md),[Consent/ex-consent-intermediate-purpose](Consent-ex-consent-intermediate-purpose.md),[Consent/ex-consent-intermediate-timeframe](Consent-ex-consent-intermediate-timeframe.md),[Consent/ex-dissent-intermediate-break-glass](Consent-ex-dissent-intermediate-break-glass.md)and[IntermediateConsent](StructureDefinition-IHE.PCF.consentIntermediate.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [Observation/ex-bloodPressure](Observation-ex-bloodPressure.md), [Observation/ex-bloodSugar](Observation-ex-bloodSugar.md), [Observation/ex-weight](Observation-ex-weight.md) and [Observation/ex-weight-2](Observation-ex-weight-2.md)
* [Provenance participant type](http://terminology.hl7.org/6.5.0/CodeSystem-provenance-participant-type.html): [Provenance/SlsSensitive-initial-history](Provenance-SlsSensitive-initial-history.md), [Provenance/SlsSensitive-split-history](Provenance-SlsSensitive-split-history.md), [Provenance/SlsSensitive-update-history](Provenance-SlsSensitive-update-history.md), [Provenance/ex-provenance-consent-basic-treat](Provenance-ex-provenance-consent-basic-treat.md) and [Provenance/ex-provenance2-consent-basic-treat](Provenance-ex-provenance2-consent-basic-treat.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [AdvancedConsent](StructureDefinition-IHE.PCF.consentAdvanced.md), [AdvancedSecurityTagVS](ValueSet-AdvancedSecurityTagVS.md)...Show 4 more,[Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md),[Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md),[Encounter/ex-encounter](Encounter-ex-encounter.md)and[Observation/ex-alcoholUse](Observation-ex-alcoholUse.md)
* [ActReason](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html): [BasicConsent](StructureDefinition-IHE.PCF.consentBasic.md), [BasicPurposeVS](ValueSet-BasicPurposeVS.md)...Show 41 more,[Consent/ex-consent-advanced-normal](Consent-ex-consent-advanced-normal.md),[Consent/ex-consent-advanced-normal-break-glass-restricted](Consent-ex-consent-advanced-normal-break-glass-restricted.md),[Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md),[Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md),[Consent/ex-consent-advanced-normal-focused-restricted](Consent-ex-consent-advanced-normal-focused-restricted.md),[Consent/ex-consent-advanced-normal-not-restricted](Consent-ex-consent-advanced-normal-not-restricted.md),[Consent/ex-consent-advanced-normal-restricted](Consent-ex-consent-advanced-normal-restricted.md),[Consent/ex-consent-basic-ink](Consent-ex-consent-basic-ink.md),[Consent/ex-consent-basic-reject](Consent-ex-consent-basic-reject.md),[Consent/ex-consent-basic-research](Consent-ex-consent-basic-research.md),[Consent/ex-consent-basic-treat](Consent-ex-consent-basic-treat.md),[Consent/ex-consent-basic-treat-infant](Consent-ex-consent-basic-treat-infant.md),[Consent/ex-consent-expired-treat](Consent-ex-consent-expired-treat.md),[Consent/ex-consent-intermediate-authoredby](Consent-ex-consent-intermediate-authoredby.md),[Consent/ex-consent-intermediate-data](Consent-ex-consent-intermediate-data.md),[Consent/ex-consent-intermediate-encounter](Consent-ex-consent-intermediate-encounter.md),[Consent/ex-consent-intermediate-not-authoredby](Consent-ex-consent-intermediate-not-authoredby.md),[Consent/ex-consent-intermediate-not-data](Consent-ex-consent-intermediate-not-data.md),[Consent/ex-consent-intermediate-not-encounter](Consent-ex-consent-intermediate-not-encounter.md),[Consent/ex-consent-intermediate-not-timeframe](Consent-ex-consent-intermediate-not-timeframe.md),[Consent/ex-consent-intermediate-purpose](Consent-ex-consent-intermediate-purpose.md),[Consent/ex-consent-intermediate-timeframe](Consent-ex-consent-intermediate-timeframe.md),[Consent/ex-dissent-intermediate-break-glass](Consent-ex-dissent-intermediate-break-glass.md),[DocumentReference/ex-documentreference](DocumentReference-ex-documentreference.md),[Encounter/ex-encounter](Encounter-ex-encounter.md),[Observation/ex-alcoholUse](Observation-ex-alcoholUse.md),[Observation/ex-bloodPressure](Observation-ex-bloodPressure.md),[Observation/ex-bloodSugar](Observation-ex-bloodSugar.md),[Observation/ex-weight](Observation-ex-weight.md),[Observation/ex-weight-2](Observation-ex-weight-2.md),[Patient/ex-mother](Patient-ex-mother.md),[Patient/ex-patient](Patient-ex-patient.md),[Practitioner/ex-author](Practitioner-ex-author.md),[Practitioner/ex-clerk](Practitioner-ex-clerk.md),[Practitioner/ex-practitioner](Practitioner-ex-practitioner.md),[Provenance/SlsSensitive-initial-history](Provenance-SlsSensitive-initial-history.md),[Provenance/SlsSensitive-split-history](Provenance-SlsSensitive-split-history.md),[Provenance/SlsSensitive-update-history](Provenance-SlsSensitive-update-history.md),[Those users that the organization authorizes to use Break-Glass](Group-ex-privilegedUsers.md),[research house org](Organization-ex-org-researcher.md)and[somewhere org](Organization-ex-organization.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [AdvancedConsent](StructureDefinition-IHE.PCF.consentAdvanced.md), [AdvancedSecurityTagVS](ValueSet-AdvancedSecurityTagVS.md)...Show 17 more,[Consent/ex-consent-advanced-normal](Consent-ex-consent-advanced-normal.md),[Consent/ex-consent-advanced-normal-break-glass-restricted](Consent-ex-consent-advanced-normal-break-glass-restricted.md),[Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md),[Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md),[Consent/ex-consent-advanced-normal-focused-restricted](Consent-ex-consent-advanced-normal-focused-restricted.md),[Consent/ex-consent-advanced-normal-not-restricted](Consent-ex-consent-advanced-normal-not-restricted.md),[Consent/ex-consent-advanced-normal-restricted](Consent-ex-consent-advanced-normal-restricted.md),[Encounter/ex-encounter](Encounter-ex-encounter.md),[Observation/ex-alcoholUse](Observation-ex-alcoholUse.md),[Observation/ex-bloodPressure](Observation-ex-bloodPressure.md),[Observation/ex-bloodSugar](Observation-ex-bloodSugar.md),[Observation/ex-weight](Observation-ex-weight.md),[Observation/ex-weight-2](Observation-ex-weight-2.md),[Practitioner/ex-author](Practitioner-ex-author.md),[Practitioner/ex-clerk](Practitioner-ex-clerk.md),[Practitioner/ex-practitioner](Practitioner-ex-practitioner.md)and[somewhere org](Organization-ex-organization.md)
* [DataOperation](http://terminology.hl7.org/6.5.0/CodeSystem-v3-DataOperation.html): [Provenance/SlsSensitive-initial-history](Provenance-SlsSensitive-initial-history.md), [Provenance/SlsSensitive-split-history](Provenance-SlsSensitive-split-history.md), [Provenance/SlsSensitive-update-history](Provenance-SlsSensitive-update-history.md), [Provenance/ex-provenance-consent-basic-treat](Provenance-ex-provenance-consent-basic-treat.md) and [Provenance/ex-provenance2-consent-basic-treat](Provenance-ex-provenance2-consent-basic-treat.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [AdvancedConsent](StructureDefinition-IHE.PCF.consentAdvanced.md), [BasicConsent](StructureDefinition-IHE.PCF.consentBasic.md)...Show 7 more,[Consent/ex-consent-advanced-normal-break-glass-restricted](Consent-ex-consent-advanced-normal-break-glass-restricted.md),[Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md),[Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md),[Consent/ex-consent-advanced-normal-focused-restricted](Consent-ex-consent-advanced-normal-focused-restricted.md),[Consent/ex-consent-intermediate-purpose](Consent-ex-consent-intermediate-purpose.md),[Consent/ex-dissent-intermediate-break-glass](Consent-ex-dissent-intermediate-break-glass.md)and[IntermediateConsent](StructureDefinition-IHE.PCF.consentIntermediate.md)


| | | |
| :--- | :--- | :--- |
|  [<prev](other.md) | [top](#top) |  [next>](testplan.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

