# 3:5.8 Privacy Consent Patterns - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* **3:5.8 Privacy Consent Patterns**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

## 3:5.8 Privacy Consent Patterns

* [3:5.8.1 Foundation Policies](#3581-foundation-policies)
* [3:5.8.2 Basic](#3582-basic)
* [3:5.8.3 Intermediate](#3583-intermediate)
* [3:5.8.4 Advanced](#3584-advanced)

The following are the FHIR Consent profiling for the PCF profile. The FHIR Consent fundamentals are [explained in Appendix P](ch-P.md#FHIR-Explainer).

### 3:5.8.1 Foundation Policies

The [Foundation Consent](StructureDefinition-IHE.PCF.consentBasic.md) Content Profile indicates the common constraints for all of PCF. There are no examples of this as there is no intended use of this profile.

### 3:5.8.2 Basic

Using [Basic Consent](StructureDefinition-IHE.PCF.consentBasic.md) Content Profile

Examples for this Resource Profile:

* [Basic Consent to sharing for Treatment policy](Consent-ex-consent-basic-treat.md) 
* ITI-71 [access token](Consent-ex-consent-basic-treat.md#notes)
 
* [Basic Consent with an Ink signature](Consent-ex-consent-basic-ink.md) 
* ITI-71 [access token](Consent-ex-consent-basic-ink.md#notes)
 
* [Basic Consent that Rejects the base policy given](Consent-ex-consent-basic-reject.md) – This could also be a representation of a situation when the patient has changed to rejection of a prior agreement 
* ITI-71 [access token](Consent-ex-consent-basic-reject.md#notes)
 
* [Consent that has expired](Consent-ex-consent-expired-treat.md) 
* ITI-71 [access token](Consent-ex-consent-expired-treat.md#notes)
 

### 3:5.8.3 Intermediate

Using [Intermediate Consent](StructureDefinition-IHE.PCF.consentIntermediate.md) Content Profile

Examples for this Resource Profile:

* restricted Consent to data [authored in a timeframe](Consent-ex-consent-intermediate-timeframe.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-timeframe.md#notes)
 
* restricted **exception** to data [authored in a timeframe](Consent-ex-consent-intermediate-not-timeframe.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-not-timeframe.md#notes)
 
* restricted consent to a [named set of data](Consent-ex-consent-intermediate-data.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-data.md#notes)
 
* restricted **exception** to a [named set of data](Consent-ex-consent-intermediate-not-data.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-not-data.md#notes)
 
* restricted consent to [data authored by a Practitioner](Consent-ex-consent-intermediate-authoredby.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-authoredby.md#notes)
 
* restricted **exception** to [data authored by a Practitioner](Consent-ex-consent-intermediate-not-authoredby.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-not-authoredby.md#notes)
 
* restricted consent to data [related to an encounter](Consent-ex-consent-intermediate-encounter.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-encounter.md#notes)
 
* restricted **exception** to data [related to an encounter](Consent-ex-consent-intermediate-not-encounter.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-not-encounter.md#notes)
 
* restricted consent to specific [intermediate purpose of use](Consent-ex-consent-intermediate-purpose.md) 
* ITI-71 [access token](Consent-ex-consent-intermediate-purpose.md#notes)
 
* [Dissent except for Break-Glass](Consent-ex-dissent-intermediate-break-glass.md). 
* ITI-71 [access token](Consent-ex-dissent-intermediate-break-glass.md#notes)
 

#### 3:5.8.3.1 Example of Intermediate by ID Search Set Bundle Processing

Given using Intermediate consent that identifies one Observation with id=1 not be shared. Like [named set of data](Consent-ex-consent-intermediate-not-data.md). The [Consent Authorization Server](volume-1.md#consentAuthorizationServer) would provide ITI-71 [access token](Consent-ex-consent-intermediate-not-data.md#notes) which is communicated to the [Consent Enforcement Point](volume-1.md#consentEnforcementPoint). The [Consent Enforcement Point](volume-1.md#consentEnforcementPoint) would first allow the Search to happen, and the raw output from a FHIR search would include all observations including the forbidden Observation. That would look like:

**3:5.8.3.1-1 Figure: Search Set Bundle before enforcement**


The Bundle would then be processed by the [Consent Enforcement Point](volume-1.md#consentEnforcementPoint), which will remove any Observations with id=1. Thus the first entry would be removed and the total decremented. The result would look like the following and be what is returned by the Grouped Server:

**3:5.8.4.1-3 Figure: Search Set Bundle post enforcement to remove Alcohol Use Disorder**


### 3:5.8.4 Advanced

Using [Advanced Consent](StructureDefinition-IHE.PCF.consentAdvanced.md) Content Profile

Examples for this Resource Profile:

* Consent to [allow NORMAL data access](Consent-ex-consent-advanced-normal.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal.md#notes)
 
* Consent to [allow NORMAL and RESTRICTED data access](Consent-ex-consent-advanced-normal-restricted.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-restricted.md#notes)
 
* Consent to [allow NORMAL data access but not RESTRICTED](Consent-ex-consent-advanced-normal-not-restricted.md) – This adds the not restricted which should not be needed as the root only authorizes NORMAL 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-not-restricted.md#notes)
 
* Consent to [allow NORMAL data access, and some access to RESTRICTED](Consent-ex-consent-advanced-normal-focused-restricted.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-focused-restricted.md#notes)
 
* Consent to [allow NORMAL data access, and some access to Mental Health](Consent-ex-consent-advanced-normal-focused-psy.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-focused-psy.md#notes)
 
* Consent to [allow NORMAL data access, and some access to Mental Health and Sexual Health](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md#notes)
 
* Consent to [allow NORMAL data access, and break-glass access to RESTRICTED](Consent-ex-consent-advanced-normal-break-glass-restricted.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-break-glass-restricted.md#notes)
 

#### 3:5.8.4.1 Example of Advanced Search Set Bundle Processing

Given using Advanced consent that identifies that no Alcohol Use Disorder information shall be shared, and using the SLS model of "Query/Use enforcement" discussed in [Appendix P: Security Labeling Service Models](ch-P.md#p5-security-labeling-service-models). Note that there are other SLS architecture models, the "Query/Use enforcement" is being used only for illustrative purposes. The [Consent Authorization Server](volume-1.md#consentAuthorizationServer) would provide ITI-71 an Access Token indicating no Alcohol Use Disorder information is allowed is communicated to the [Consent Enforcement Point](volume-1.md#consentEnforcementPoint). The [Consent Enforcement Point](volume-1.md#consentEnforcementPoint) would first allow the Search to happen, and the raw output from a FHIR search would include all observations including the forbidden Observation. That would look like:

**3:5.8.4.1-1 Figure: Search Set Bundle before SLS tagging**


In the "Query/Use enforcement" the Bundle would then be processed by the SLS and sensitivity and confidentiality tags would be added:

**3:5.8.4.1-2 Figure: Search Set Bundle after SLS tagging**


The tagged Bundle would then be processed by the [Consent Enforcement Point](volume-1.md#consentEnforcementPoint), which will remove any Alcohol use Disorder information. Thus the first entry would be removed and the total decremented. The result would look like the following and be what is returned by the Grouped Server:

**3:5.8.4.1-3 Figure: Search Set Bundle post enforcement to remove Alcohol Use Disorder**


Note that the data returned may have the resulting security tags that the SLS applied, or those tags may be removed prior to the Grouped Server returning the results to the Grouped Client. This exposure of the tags is a policy decision that the PCF does not mandate.

| | | |
| :--- | :--- | :--- |
|  [<prev](ITI-108.md) | [top](#top) |  [next>](other.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

