# Artifacts Summary - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

## Artifacts Summary

Contents:

*  [Explicit Basic Consent](#1) 
*  [Explicit Intermediate Consent](#2) 
*  [Explicit Advanced Consent](#3) 
*  [Security Labeling Service resources](#4) 
*  [Behavior: Capability Statements](#5) 
*  [Example: Example Instances](#6) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Explicit Basic Consent 

Artifacts related to [Explicit Basic option](volume-1.md#15322-explicit-basic-option)

| | |
| :--- | :--- |
| [Basic Purpose ValueSet](ValueSet-BasicPurposeVS.md) | ValueSet of the PurposeOfUse minimally extensible by Basic Option |
| [Binary example using Binary](Binary-B-ink.md) | Example of a binary ink signed document. |
| [Binary example using DocumentReference](DocumentReference-ex-consent-ink.md) | Example of a scanned image of an ink signature in binary using DocumentReference. |
| [Clerk Practitioner example](Practitioner-ex-clerk.md) | Clerk Practitioner example used as an example Clerk managing Consents |
| [Consent for access for treatment example given by mother to infants data](Consent-ex-consent-basic-treat-infant.md) | Consent for purposes of use involved in Treatment/Payment/Operations, to an infants data, given by the motherThis is a BasicConsent example:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the mother 
* same pattern is used when the performer is an adult child giving consent onbehalf of elderly mother, or a power-of-attorney giving access to a disabled patient's data.
 
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
 |
| [Consent for any Healthcare Research example](Consent-ex-consent-basic-research.md) | Consent for any healthcare research purposeThis is a BasicConsent:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes HRESCH to indicate all Healthcare Research
Note that in this case the HRESCH is not part of the extensible ValueSet for BasicConsent, but because it is not within that ValueSet then it is allowed as extensible. Also note that HRESCH is a top level (ontological) code covering all possible forms of healthcare research. Thus the Permit on this top level concept is a Permit on all sub concepts including specific projects that the organization defines within this top level concept. |
| [Consent for purpose of treatment example](Consent-ex-consent-basic-treat.md) | Consent for purposes of use involved in treatment: Treatment/Payment/OperationsThis is a BasicConsent example:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
 |
| [Consent for treatment example with expiration](Consent-ex-consent-expired-treat.md) | Consent that includes an expiration.This is a BasicConsent, that has expired, example:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
* **provision period end was at December 31, 2022 – thus this Consent has expired.**
 |
| [Consent for treatment example with ink signature](Consent-ex-consent-basic-ink.md) | Consent for purposes of use involved in treatment: Treatment/Payment/OperationsThis is a BasicConsent example:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference – Ink signature on paper
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
 |
| [Dissent for treatment example](Consent-ex-consent-basic-reject.md) | Dissent for purposes of use involved in treatment: Treatment/Payment/OperationsThis is a BasicConsent example:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* **base provision is #deny – rejecting the indicated policy**
* base provision includes TPO so as to be clear this is a consent about TPO
 |
| [DocumentReference Consent Paperwork example](DocumentReference-ex-documentreference.md) | DocumentReference example of the paperwork of the ConsentThis is showing an example of a document that is purely text. |
| [Example Organization holding the data](Organization-ex-organization.md) | The Organization that holds the data, and enforcing any Consents |
| [Example Patient](Patient-ex-patient.md) | The patient from which all the example relate |
| [IHE PCF Explicit Basic Consent](StructureDefinition-IHE.PCF.consentBasic.md) | Explicit Basic Consent* status 1..1 - would indicate active
* scope 1..1 - #patient-privacy
* category 1..1 - would indicate patient consent, specifically a delegation of authority
* identifier 0..1 - no defined use in PCF. This could carry business identifiers assigned to the consent instance
* patient 1..1 - would indicate the Patient resource reference for the given patient
* dateTime 1..1 - would indicate when the privacy policy was presented
* performer 1.. - would indicate the Patient resource if the patient was presented, a RelatedPerson for parent or guardian
* organization 1.. - would indicate the Organization that presented the privacy policy, and that is going to enforce that privacy policy
* source 1..1 - would point at the specific signed consent by the patient
* policy.uri 1..1 - would indicate the privacy policy that was presented. Usually, the url to the version-specific policy
* provision.type 1..1 - permit indicates agreement with the policy, deny would indicate rejection.
* provision.actor 0..* - would indicate those being granted permit / denied access, if empty then all in the community
* provision.actor.role - fixed value IRCP to indicate information recipient.
* provision.purpose - would indicate some set of authorized purposeOfUse
* provision.period MS - would indicate a sunset for the consent if applicable, empty means no expiration
* provision.provisions are allowed
Not defined in PCF, but allowed* policy.authority - **not used** in PCF
* policyRule - **not used** in PCF
Not allowed in PCF* provision.provision.provisions - **NOT allowed**, no clear use-case need and would add complexity
* verification - **not used** in PCF, unclear the use-case need
* provision.action - **not used** in PCF. The purpose is sufficient.
* provision.class - **not used** in PCF, unclear the use-case need
* provision.code - **not used** in PCF, unclear the use-case need
Specifics of Basic:* provision.purpose - would indicate some set of authorized purposeOfUse only Treatment, Payment, or Operations, see Intermediate
* provision.securityLabel is not allowed, see Intermediate
* provision.dataPeriod is not allowed, see Intermediate
* provision.data is nto allowed, see Intermediate
* provision.provision are NOT allowed, see Intermediate
 |
| [Provenance of Create of a basic consent](Provenance-ex-provenance-consent-basic-treat.md) | Given a Consent is created, and AuditEvent is not seen as sufficient, This example provides an example of Provenance that would be equivilant. |
| [Provenance of Update of a basic consent](Provenance-ex-provenance2-consent-basic-treat.md) | Given a Consent is updated, and AuditEvent is not seen as sufficient, This example provides an example of Provenance that would be equivilant. |

### Explicit Intermediate Consent 

Artifacts related to [Explicit Intermediate](volume-1.md#15323-explicit-intermediate-options) option

| | |
| :--- | :--- |
| [Consent allowing data access for a given intermediate purpose](Consent-ex-consent-intermediate-purpose.md) | Consent allowing data access for a given intermediate purposeThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* base provision is #permit – accepting the policy
This is the Intermediate part:* Intermediate PurposeOfUse are those that fall outside the basic purposeOfUse valueset
* In this case the PurposeOfUse will be for a Clinical Research Project – FooBar
* given that the intermediate purpose is a Clinical Research project, then the policy URI will also be different
* allowing a given purpose beyond the basic purpose valueSet
* Given this is a research project, also have included the research organization as actor 
* [research org](Organization-ex-org-researcher.md)
 
 |
| [Consent allowing data authored by a practitioner](Consent-ex-consent-intermediate-authoredby.md) | Consent allowing data authored byThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* Permits access to data authored by [practitioner 1](Practitioner-ex-practitioner.md)
 |
| [Consent allowing data authored related to an encounter](Consent-ex-consent-intermediate-encounter.md) | Consent allowing data authored related to an encounterThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* authored within an encounter 
* [encounter 1](Encounter-ex-encounter.md)
 
 |
| [Consent allowing data authored within a timeframe](Consent-ex-consent-intermediate-timeframe.md) | Consent allowing data authored within a timeframeThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* access only data authored within 2022
 |
| [Consent allowing most sharing but NOT data authored by a practitioner](Consent-ex-consent-intermediate-not-authoredby.md) | Consent allowing most sharing of data but NOT data authored by a practitionerThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* a sub-provision denying access to data authored by ex-practitioner 
* [practitioner 1](Practitioner-ex-practitioner.md)
 
 |
| [Consent allowing most sharing but NOT data authored within a timeframe](Consent-ex-consent-intermediate-not-timeframe.md) | Consent allowing most sharing of data but NOT data authored within a timeframeThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* permit form most uses
* a sub-provision denying access to data authored within 2022
 |
| [Consent allowing most sharing but NOT data related to an encounter](Consent-ex-consent-intermediate-not-encounter.md) | Consent allowing most sharing of data but NOT data related to an encounterThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* a sub-provision denying access to data authored within an encounter 
* [encounter 1](Encounter-ex-encounter.md)
 
 |
| [Consent allowing most sharing but NOT specific data](Consent-ex-consent-intermediate-not-data.md) | Consent allowing most sharing of data but NOT specific dataThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* a sub-provision denying access to a specific data instance 
* [alcohol use 1](Observation-ex-alcoholUse.md)
 
 |
| [Consent allowing specific data](Consent-ex-consent-intermediate-data.md) | Consent allowing specific dataThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Intermediate part:* with specific data itemized. 
* [alcohol use 1](Observation-ex-alcoholUse.md)
* [blood sugar 1](Observation-ex-bloodSugar.md)
* [blood pressure 1](Observation-ex-bloodPressure.md)
* [weight 1](Observation-ex-weight.md)
* [weight 2](Observation-ex-weight-2.md)
* [encounter 1](Encounter-ex-encounter.md)
 
 |
| [Consent forbid data access except for Break-Glass](Consent-ex-dissent-intermediate-break-glass.md) | Consent forbid data access except for Break-GlassThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* base policy is Policy-break-glass-only
* base provision is #deny access given the overriding policy
This is the Intermediate part:* sub-provision permits users on the managed group of authorized to break-glass 
* Note that the consent would not need to point at the group as it would be understood. But I point at a group for illustrative purposes.
 
 |
| [Dummy Practitioner example](Practitioner-ex-practitioner.md) | Dummy Practitioner example for completeness sake. No actual use of this resource other than an example target |
| [Example Encounter](Encounter-ex-encounter.md) | holding typical values |
| [Example Organization doing the FooBar Research](Organization-ex-org-researcher.md) | The Organization that is allowed access for FooBar research project |
| [IHE PCF Explicit Intermediate Consent](StructureDefinition-IHE.PCF.consentIntermediate.md) | Explicit Intermediate Consent* all elements allowed by Basic are allowed here, plus the following
* restriction at the root `.provision` apply to the whole Consent 
* restrictions at the `.provision.provision` are exceptions to the base consent
* no `.provision.provision.provisions` are allowed
 
* data authored in a timeframe is specified in the `.dataPeriod` element
* explicit data objects are indicated in the `.data` element with `.meaning` of `#instance`
* data with relationship to an object are indicated in a `.data` element with `.meaning` of `#related`
* data authored by a given actor is indicated in the `.data` element with `.meaning` of `#authoredby`
* purposes of use activities are indicated in the `.purpose` element
* `securityLabel` is not allowed, see Advanced
 |
| [Those users that the organization authorizes to use Break-Glass](Group-ex-privilegedUsers.md) | This is a managed list of users that are authorzed to Break-Glass. The list is managed by the treatment Organization. |

### Explicit Advanced Consent 

Artifacts related to [Explicit Advanced](volume-1.md#15324-explicit-advanced-option) option

| | |
| :--- | :--- |
| [Advanced Security Tag ValueSet](ValueSet-AdvancedSecurityTagVS.md) | ValueSet of the security tags allowed in Advanced Consent OptionAt a minimum the following stigmatizing[Sensitivity](https://terminology.hl7.org/ValueSet-v3-InformationSensitivityPolicy.html)classifications shall be implemented as parameters:* `ETH` – Substance Abuse including Alcohol 
* `ETHUD` – Alcohol substance abuse
* `OPIOIDUD` – Opioid drug abuse
 
* `PSY` – Psychiatry Disorder / Mental Health
* `SDV` – Sexual Assault, Abuse, or Domestic Violence
* `HIV` – HIV/AIDS
At a minimum the following[ConfidentialityCodes](https://terminology.hl7.org/ValueSet-v3-Confidentiality.html)shall be implemented as parameters:* `N` Normal and
* `R` Restricted
 |
| [Consent allowing NORMAL and break-glass access to RESTRICTED data](Consent-ex-consent-advanced-normal-break-glass-restricted.md) | Consent allowing NORMAL and break-glass access to RESTRICTED (e.g., Mental Health or Sexual Health) data.This is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal data only
* only break-glass gets RESTRICTED data
 |
| [Consent allowing NORMAL and focused access to Mental Health or Sexual Health data](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md) | Consent allowing NORMAL and focused access to Mental Health or Sexual Health data.This is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal data only
* only [Practitioner](Practitioner-ex-practitioner.md) gets Mental Health or Sexual Health data
 |
| [Consent allowing NORMAL and focused Mental Health data access](Consent-ex-consent-advanced-normal-focused-psy.md) | Consent allowing NORMAL data access but only focused Mental Health Abuse.This is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal data only
* only [Practitioner](Practitioner-ex-practitioner.md) gets Mental Health data only
 |
| [Consent allowing NORMAL and focused RESTRICTED data access](Consent-ex-consent-advanced-normal-focused-restricted.md) | Consent allowing NORMAL data access but only focused RESTRICTED.This is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal data only
* only [Practitioner](Practitioner-ex-practitioner.md) gets Restricted data only
 |
| [Consent allowing NORMAL and RESTRICTED data access](Consent-ex-consent-advanced-normal-restricted.md) | Consent allowing NORMAL and RESTRICTED data accessThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal and Restricted data only
 |
| [Consent allowing NORMAL but not RESTRICTED data access](Consent-ex-consent-advanced-normal-not-restricted.md) | Consent allowing NORMAL data access but NOT RESTRICTED. The exclusion of RESTRICTED should not be needed, given permit is only NormalThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal data only
* Not Restricted data only
 |
| [Consent allowing NORMAL data access](Consent-ex-consent-advanced-normal.md) | Consent allowing NORMAL data accessThis is the Basic part:* status is active - so it should be enforced
* scope is privacy
* category is LOINC 59284-0 Consent
* date indicated when the consent is recorded
* patient is identified
* performer is the patient
* organization is identified
* source indicate a DocumentReference (with included text of the policy)
* policy url is to a base policy
* base provision is #permit – accepting the policy
* base provision includes TPO so as to be clear this is a consent about TPO
This is the Advanced part:* Normal data only
 |
| [IHE PCF Explicit Advanced Consent](StructureDefinition-IHE.PCF.consentAdvanced.md) | Explicit Advanced Consent* all elements allowed by Basic and Intermediate are allowed here, plus the following
* `securityLabel` indicates sensitivity or confidentiality tags on data 
* Only codes from [Avanced Security Tag ValueSet](ValueSet-AdvancedSecurityTagVS.md)
 
 |

### Security Labeling Service resources 

Artifacts to support a [Security Labeling Service (SLS)](ch-P.md#SLS)

| | |
| :--- | :--- |
| [clinical codes that indicate ETH](ValueSet-SlsSensitiveETH.md) | codes that when found in data would indicate the data is likely ETH relatedETH - substance abuse information sensitivity (alcohol or drug-abuse information)* **SAMSHA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMSHA C2S Amphetamine Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC
 
* **SAMSHA C2S Cannabis Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT
 
* **SAMSHA C2S Cocaine Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT
 
* **SAMSHA C2S Hallucinogens** 
* ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT
 
* **SAMSHA C2S Inhalants** 
* ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT
 
* **SAMSHA C2S Opioids** 
* ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT
 
* **SAMSHA C2S Other Psychoactive Substance Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM
 
* **SAMSHA C2S Sedative Hypnotic, or anxiolytic related disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM
 
* **SAMSHA C2S Substance use Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM
 
* **SAMSHA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 |
| [clinical codes that indicate ETHUD](ValueSet-SlsSensitiveETHUD.md) | codes that when found in data would indicate the data is likely ETHUD relatedETHUD - alcohol abuse information sensitivity (alcohol abuse information)* **SAMSHA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMSHA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 |
| [clinical codes that indicate HIV](ValueSet-SlsSensitiveHIV.md) | HIV/AIDS information* **SAMSHA C2S HIV/AIDS Information** 
* ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT
 
* **SAMSHA Test C2S HIV/AIDS Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD
 
 |
| [clinical codes that indicate OPIOIDUD](ValueSet-SlsSensitiveOPIOIDUD.md) | codes that when found in data would indicate the data is likely OPIOIDUD relatedOPIOIDUD - Opioid substance abuse information sensitivity (drug-abuse information)* **SAMSHA C2S Amphetamine Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC
 
* **SAMSHA C2S Cannabis Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT
 
* **SAMSHA C2S Cocaine Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT
 
* **SAMSHA C2S Hallucinogens** 
* ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT
 
* **SAMSHA C2S Inhalants** 
* ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT
 
* **SAMSHA C2S Opioids** 
* ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT
 
* **SAMSHA C2S Other Psychoactive Substance Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM
 
* **SAMSHA C2S Sedative Hypnotic, or anxiolytic related disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM
 
* **SAMSHA C2S Substance use Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM
 
 |
| [clinical codes that indicate PSY](ValueSet-SlsSensitivePSY.md) | codes that when found in data would indicate the data is likely PSY relatedPSY - psychiatry disorder information sensitivity??should this include MH (Mental Health), PSYTHPN (psychotherapy note), and SUD (subsance use)??* **SAMSHA C2S Mental Health Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.32 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.33 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.34 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.35 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.36 // SNOMED-CT
 
 |
| [clinical codes that indicate SDV](ValueSet-SlsSensitiveSDV.md) | SDV - Sexual assault, abuse or domestic violence??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMSHA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease.* **SAMSHA C2S Sexuality and reproductive health information sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM
 
 |
| [Example of a blood pressure R4 observation, minimal](Observation-ex-bloodPressure.md) | holding typical values |
| [Example of a bodyWeight R4 observation](Observation-ex-weight.md) | Sample for demonstration purposes of a common weight Observation* marked as compliant with IHE.ToDo.bodyWeight profile
* marked as test data
* status of final
* category vital-signs
* code of loinc body weight
* subject of the example patient
* effective time of December 25th, 2004
* weight 185 pounds
* note: a bit heavy
 |
| [Example of an MHV blood sugar R4 observation](Observation-ex-bloodSugar.md) | holding typical health values* SLS assessed this as not sensitvie
* SLS added Normal due to not sensitive
 |
| [Example of an valid FHIR bodyWeight R4 observation, but not compliant with the profile](Observation-ex-weight-2.md) | Sample for demonstration purposes of a common weight Observation.* Given that this is not compliant, it is thus not declaring that it is compliant, it is just an Observation
* marked as test data
* status of final
* category of vital-signs
* code of loinc 29463-7 and 3141-9
* also code of snomed 27113001
* subject of the example patient
* linked to an encounter
* effectiveDateTime = March 28, 2016
* weight 280 lbs
* note: a bit heavy, about 280 lbs
 |
| [Observation - SH: Alcohol Use](Observation-ex-alcoholUse.md) | This example Observation resource to represent alcohol use assessment in a patient summary.* SLS assessed this as ETHUD
* SLS added Restricted due to the ETHUD assessment
 |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [PCF Consent Authorization Server Actor](CapabilityStatement-IHE.PCF.consentAuthorizationServer.md) | CapabilityStatement for the Consent Authorization Server ActorExplain* is a Client that uses [Access Consent [ITI-108]](ITI-108.md) to retrieve current Privacy Consent and make access control decisions based upon them
 |
| [PCF Consent Recorder Actor](CapabilityStatement-IHE.PCF.consentRecorder.md) | CapabilityStatement for the Consent Recorder ActorExplain* uses [Access Consent [ITI-108]](ITI-108.md) to record new or updated Consent Resources
 |
| [PCF Consent Registry Actor](CapabilityStatement-IHE.PCF.consentRegistry.md) | CapabilityStatement for Consent Registry Actor.Explain* provides [Access Consent [ITI-108]](ITI-108.md) to store and support access to Privacy Consent Resources
 |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Dummy Authoring Practitioner example](Practitioner-ex-author.md) | Dummy Practitioner example for completeness sake. No actual use of this resource other than an example target |
| [Mother of John](Patient-ex-mother.md) | The patient resource describing the mother |

| | | |
| :--- | :--- | :--- |
|  [<prev](issues.md) | [top](#top) |  [next>](ValueSet-BasicPurposeVS.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

