# clinical codes that indicate PSY - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate PSY**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-SlsSensitivePSY.xml.md) 
*  [JSON](ValueSet-SlsSensitivePSY.json.md) 
*  [History](ValueSet-SlsSensitivePSY.change.history.md) 

## ValueSet: clinical codes that indicate PSY (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/ValueSet/SlsSensitivePSY | *Version*:1.1.1-current |
| Draft as of 2025-10-07 | *Computable Name*:SlsSensitivePSY |

 
codes that when found in data would indicate the data is likely PSY related 
PSY - psychiatry disorder information sensitivity 
??should this include MH (Mental Health), PSYTHPN (psychotherapy note), and SUD (subsance use)?? 
* **SAMSHA C2S Mental Health Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.32 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.33 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.34 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.35 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.36 // SNOMED-CT
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [C2S Mental Health Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.32/expansion)
* Import all the codes that are contained in [C2S Mental Health Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.33/expansion)
* Import all the codes that are contained in [C2S Mental Health Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.34/expansion)
* Import all the codes that are contained in [C2S Mental Health Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.35/expansion)
* Import all the codes that are contained in [C2S Mental Health Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.36/expansion)

 

### Expansion

Expansion from tx.fhir.org based on:

* [valueset C2S Mental Health Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.32/expansion)
* [valueset C2S Mental Health Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.33/expansion)
* [valueset C2S Mental Health Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.34/expansion)
* [valueset C2S Mental Health Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.35/expansion)
* [valueset C2S Mental Health Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.36/expansion)

This value set has 1,708 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-SlsSensitiveOPIOIDUD.change.history.md) | [top](#top) |  [next>](ValueSet-SlsSensitivePSY-testing.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

