# clinical codes that indicate OPIOIDUD - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate OPIOIDUD**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-SlsSensitiveOPIOIDUD.xml.md) 
*  [JSON](ValueSet-SlsSensitiveOPIOIDUD.json.md) 
*  [History](ValueSet-SlsSensitiveOPIOIDUD.change.history.md) 

## ValueSet: clinical codes that indicate OPIOIDUD (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/ValueSet/SlsSensitiveOPIOIDUD | *Version*:1.1.1-current |
| Draft as of 2025-10-07 | *Computable Name*:SlsSensitiveOPIOIDUD |

 
codes that when found in data would indicate the data is likely OPIOIDUD related 
OPIOIDUD - Opioid substance abuse information sensitivity (drug-abuse information) 
* **SAMSHA C2S Amphetamine Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC
 
* **SAMSHA C2S Cannabis Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT
 
* **SAMSHA C2S Cocaine Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT
 
* **SAMSHA C2S Hallucinogens** 
* ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT
 
* **SAMSHA C2S Inhalants** 
* ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT
 
* **SAMSHA C2S Opioids** 
* ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT
 
* **SAMSHA C2S Other Psychoactive Substance Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM
 
* **SAMSHA C2S Sedative Hypnotic, or anxiolytic related disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM
 
* **SAMSHA C2S Substance use Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [C2S Amphetamine Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.10/expansion)
* Import all the codes that are contained in [C2S Amphetamine Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.11/expansion)
* Import all the codes that are contained in [C2S Amphetamine Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.6/expansion)
* Import all the codes that are contained in [C2S Amphetamine Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.7/expansion)
* Import all the codes that are contained in [C2S Amphetamine Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.8/expansion)
* Import all the codes that are contained in [C2S Amphetamine Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.9/expansion)
* Import all the codes that are contained in [C2S Cannabis Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.12/expansion)
* Import all the codes that are contained in [C2S Cannabis Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.13/expansion)
* Import all the codes that are contained in [C2S Cannabis Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.14/expansion)
* Import all the codes that are contained in [C2S Cannabis Use DIsorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.15/expansion)
* Import all the codes that are contained in [C2S Cocaine Use Disorder](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.16/expansion)
* Import all the codes that are contained in [C2S Cocaine Use Disorder](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.17/expansion)
* Import all the codes that are contained in [C2S Cocaine Use Disorder](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.18/expansion)
* Import all the codes that are contained in [C2S Hallucinogens](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.19/expansion)
* Import all the codes that are contained in [C2S Hallucinogens](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.20/expansion)
* Import all the codes that are contained in [C2S Hallucinogens](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.21/expansion)
* Import all the codes that are contained in [C2S Hallucinogens](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.22/expansion)
* Import all the codes that are contained in [C2S Inhalants](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.28/expansion)
* Import all the codes that are contained in [C2S Inhalants](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.29/expansion)
* Import all the codes that are contained in [C2S Inhalants](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.30/expansion)
* Import all the codes that are contained in [C2S Opioids](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.38/expansion)
* Import all the codes that are contained in [C2S Opioids](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.39/expansion)
* Import all the codes that are contained in [C2S Opioids](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.40/expansion)
* Import all the codes that are contained in [C2S Opioids](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.41/expansion)
* Import all the codes that are contained in [C2S Opioids](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.42/expansion)
* Import all the codes that are contained in [C2S Opioids](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.59/expansion)
* Import all the codes that are contained in [C2S Other Psychoactive Substance Use Disorder](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.43/expansion)
* Import all the codes that are contained in [C2S Other Psychoactive Substance Use Disorder](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.44/expansion)
* Import all the codes that are contained in [C2S Other Psychoactive Substance Use Disorder](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.45/expansion)
* Import all the codes that are contained in [C2S Sedative Hypnotic, or anxiolytic related disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.46/expansion)
* Import all the codes that are contained in [C2S Sedative Hypnotic, or anxiolytic related disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.47/expansion)
* Import all the codes that are contained in [C2S Sedative Hypnotic, or anxiolytic related disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.48/expansion)
* Import all the codes that are contained in [C2S Substance Use Information Sensitivity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.55/expansion)
* Import all the codes that are contained in [C2S Substance Use Information Sensitivity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.56/expansion)
* Import all the codes that are contained in [C2S Substance Use Information Sensitivity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.57/expansion)

 

### Expansion

Expansion from tx.fhir.org based on:

* [valueset C2S Amphetamine Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.10/expansion)
* [valueset C2S Amphetamine Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.11/expansion)
* [valueset C2S Cannabis Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.12/expansion)
* [valueset C2S Cannabis Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.13/expansion)
* [valueset C2S Cannabis Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.14/expansion)
* [valueset C2S Cannabis Use DIsorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.15/expansion)
* [valueset C2S Cocaine Use Disorder v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.16/expansion)
* [valueset C2S Cocaine Use Disorder v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.17/expansion)
* [valueset C2S Cocaine Use Disorder v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.18/expansion)
* [valueset C2S Hallucinogens v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.19/expansion)
* [valueset C2S Hallucinogens v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.20/expansion)
* [valueset C2S Hallucinogens v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.21/expansion)
* [valueset C2S Hallucinogens v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.22/expansion)
* [valueset C2S Inhalants v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.28/expansion)
* [valueset C2S Inhalants v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.29/expansion)
* [valueset C2S Inhalants v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.30/expansion)
* [valueset C2S Opioids v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.38/expansion)
* [valueset C2S Opioids v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.39/expansion)
* [valueset C2S Opioids v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.40/expansion)
* [valueset C2S Opioids v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.41/expansion)
* [valueset C2S Opioids v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.42/expansion)
* [valueset C2S Other Psychoactive Substance Use Disorder v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.43/expansion)
* [valueset C2S Other Psychoactive Substance Use Disorder v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.44/expansion)
* [valueset C2S Other Psychoactive Substance Use Disorder v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.45/expansion)
* [valueset C2S Sedative Hypnotic, or anxiolytic related disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.46/expansion)
* [valueset C2S Sedative Hypnotic, or anxiolytic related disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.47/expansion)
* [valueset C2S Sedative Hypnotic, or anxiolytic related disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.48/expansion)
* [valueset C2S Substance Use Information Sensitivity v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.55/expansion)
* [valueset C2S Substance Use Information Sensitivity v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.56/expansion)
* [valueset C2S Substance Use Information Sensitivity v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.57/expansion)
* [valueset C2S Opioids v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.59/expansion)
* [valueset C2S Amphetamine Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.6/expansion)
* [valueset C2S Amphetamine Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.7/expansion)
* [valueset C2S Amphetamine Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.8/expansion)
* [valueset C2S Amphetamine Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.9/expansion)

This value set has 2,004 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-SlsSensitiveHIV.change.history.md) | [top](#top) |  [next>](ValueSet-SlsSensitiveOPIOIDUD-testing.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

