# clinical codes that indicate ETHUD - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate ETHUD**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-SlsSensitiveETHUD.xml.md) 
*  [JSON](ValueSet-SlsSensitiveETHUD.json.md) 
*  [History](ValueSet-SlsSensitiveETHUD.change.history.md) 

## ValueSet: clinical codes that indicate ETHUD (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/ValueSet/SlsSensitiveETHUD | *Version*:1.1.1-current |
| Draft as of 2025-10-07 | *Computable Name*:SlsSensitiveETHUD |

 
codes that when found in data would indicate the data is likely ETHUD related 
ETHUD - alcohol abuse information sensitivity (alcohol abuse information) 
* **SAMSHA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMSHA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [C2S Alcohol Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.1/expansion)
* Import all the codes that are contained in [C2S Alcohol Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.2/expansion)
* Import all the codes that are contained in [C2S Alcohol Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.3/expansion)
* Import all the codes that are contained in [C2S Alcohol Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.4/expansion)
* Import all the codes that are contained in [C2S Alcohol Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.5/expansion)
* Import all the codes that are contained in [Test C2S Alcohol Use Disorders](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.65/expansion)

 

### Expansion

Expansion from tx.fhir.org based on:

* [valueset C2S Alcohol Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.1/expansion)
* [valueset C2S Alcohol Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.2/expansion)
* [valueset C2S Alcohol Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.3/expansion)
* [valueset C2S Alcohol Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.4/expansion)
* [valueset C2S Alcohol Use Disorders v20160909 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.5/expansion)
* [valueset Test C2S Alcohol Use Disorders v20190216 (ValueSet)](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.65/expansion)

This value set contains 377 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-SlsSensitiveETH.change.history.md) | [top](#top) |  [next>](ValueSet-SlsSensitiveETHUD-testing.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

