# Basic Purpose ValueSet - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Basic Purpose ValueSet**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-BasicPurposeVS.xml.md) 
*  [JSON](ValueSet-BasicPurposeVS.json.md) 

## ValueSet: Basic Purpose ValueSet 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/ValueSet/BasicPurposeVS | *Version*:1.1.1-current |
| Active as of 2025-10-07 | *Computable Name*:BasicPurposeVS |

 
ValueSet of the PurposeOfUse minimally extensible by Basic Option 

 **References** 

* [IHE PCF Explicit Basic Consent](StructureDefinition-IHE.PCF.consentBasic.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActReason`](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html) version 📦3.1.0

 

### Expansion

Expansion performed internally based on [codesystem ActReason v3.1.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html)

This value set contains 3 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

| | | |
| :--- | :--- | :--- |
|  [<prev](artifacts.md) | [top](#top) |  [next>](ValueSet-BasicPurposeVS-testing.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

