# Advanced Security Tag ValueSet - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advanced Security Tag ValueSet**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-AdvancedSecurityTagVS.xml.md) 
*  [JSON](ValueSet-AdvancedSecurityTagVS.json.md) 

## ValueSet: Advanced Security Tag ValueSet 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/ValueSet/AdvancedSecurityTagVS | *Version*:1.1.1-current |
| Active as of 2025-10-07 | *Computable Name*:AdvancedSecurityTagVS |

 
ValueSet of the security tags allowed in Advanced Consent Option 
At a minimum the following stigmatizing[Sensitivity](https://terminology.hl7.org/ValueSet-v3-InformationSensitivityPolicy.html)classifications shall be implemented as parameters: 
* `ETH` – Substance Abuse including Alcohol 
* `ETHUD` – Alcohol substance abuse
* `OPIOIDUD` – Opioid drug abuse
 
* `PSY` – Psychiatry Disorder / Mental Health
* `SDV` – Sexual Assault, Abuse, or Domestic Violence
* `HIV` – HIV/AIDS
 
At a minimum the following[ConfidentialityCodes](https://terminology.hl7.org/ValueSet-v3-Confidentiality.html)shall be implemented as parameters: 
* `N` Normal and
* `R` Restricted
 

 **References** 

* [IHE PCF Explicit Advanced Consent](StructureDefinition-IHE.PCF.consentAdvanced.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-Confidentiality`](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html) version 📦3.0.0
* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html) version 📦9.0.0 

 

### Expansion

Expansion performed internally based on:

* [codesystem ActCode v9.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html)
* [codesystem Confidentiality v3.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html)

This value set contains 8 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

| | | |
| :--- | :--- | :--- |
|  [<prev](Group-ex-privilegedUsers.ttl.md) | [top](#top) |  [next>](ValueSet-AdvancedSecurityTagVS-testing.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

