# IHE PCF Explicit Intermediate Consent - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE PCF Explicit Intermediate Consent**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-IHE.PCF.consentIntermediate-definitions.md) 
*  [Mappings](StructureDefinition-IHE.PCF.consentIntermediate-mappings.md) 
*  [Examples](StructureDefinition-IHE.PCF.consentIntermediate-examples.md) 
*  [XML](StructureDefinition-IHE.PCF.consentIntermediate.profile.xml.md) 
*  [JSON](StructureDefinition-IHE.PCF.consentIntermediate.profile.json.md) 

## Resource Profile: IHE PCF Explicit Intermediate Consent 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/StructureDefinition/IHE.PCF.consentIntermediate | *Version*:1.1.1-current |
| Active as of 2025-10-07 | *Computable Name*:IntermediateConsent |

 
Explicit Intermediate Consent 
* all elements allowed by Basic are allowed here, plus the following
* restriction at the root `.provision` apply to the whole Consent 
* restrictions at the `.provision.provision` are exceptions to the base consent
* no `.provision.provision.provisions` are allowed
 
* data authored in a timeframe is specified in the `.dataPeriod` element
* explicit data objects are indicated in the `.data` element with `.meaning` of `#instance`
* data with relationship to an object are indicated in a `.data` element with `.meaning` of `#related`
* data authored by a given actor is indicated in the `.data` element with `.meaning` of `#authoredby`
* purposes of use activities are indicated in the `.purpose` element
* `securityLabel` is not allowed, see Advanced
 

**Usages:**

* Examples for this Profile: [Consent/ex-consent-intermediate-authoredby](Consent-ex-consent-intermediate-authoredby.md), [Consent/ex-consent-intermediate-data](Consent-ex-consent-intermediate-data.md), [Consent/ex-consent-intermediate-encounter](Consent-ex-consent-intermediate-encounter.md), [Consent/ex-consent-intermediate-not-authoredby](Consent-ex-consent-intermediate-not-authoredby.md)...Show 6 more,[Consent/ex-consent-intermediate-not-data](Consent-ex-consent-intermediate-not-data.md),[Consent/ex-consent-intermediate-not-encounter](Consent-ex-consent-intermediate-not-encounter.md),[Consent/ex-consent-intermediate-not-timeframe](Consent-ex-consent-intermediate-not-timeframe.md),[Consent/ex-consent-intermediate-purpose](Consent-ex-consent-intermediate-purpose.md),[Consent/ex-consent-intermediate-timeframe](Consent-ex-consent-intermediate-timeframe.md)and[Consent/ex-dissent-intermediate-break-glass](Consent-ex-dissent-intermediate-break-glass.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.iti.pcf|current/StructureDefinition/IHE.PCF.consentIntermediate)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 7 elements(1 nested mandatory element)
 Must-Support: 16 elements
 Prohibited: 6 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Consent.provision.data (Closed)
* The element 1 is sliced based on the value of Consent.provision.provision.data (Closed)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 7 elements(1 nested mandatory element)
 Must-Support: 16 elements
 Prohibited: 6 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Consent.provision.data (Closed)
* The element 1 is sliced based on the value of Consent.provision.provision.data (Closed)

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCF.consentIntermediate.csv), [Excel](StructureDefinition-IHE.PCF.consentIntermediate.xlsx), [Schematron](StructureDefinition-IHE.PCF.consentIntermediate.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](Organization-ex-org-researcher.ttl.md) | [top](#top) |  [next>](StructureDefinition-IHE.PCF.consentIntermediate-definitions.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

