# IHE PCF Explicit Intermediate Consent - Examples - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE PCF Explicit Intermediate Consent**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Content](StructureDefinition-IHE.PCF.consentIntermediate.md) 
*  [Detailed Descriptions](StructureDefinition-IHE.PCF.consentIntermediate-definitions.md) 
*  [Mappings](StructureDefinition-IHE.PCF.consentIntermediate-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-IHE.PCF.consentIntermediate.profile.xml.md) 
*  [JSON](StructureDefinition-IHE.PCF.consentIntermediate.profile.json.md) 

## Resource Profile: IntermediateConsent - Examples

| |
| :--- |
| Active as of 2025-10-07 |

Examples for the IHE.PCF.consentIntermediate Profile.

| |
| :--- |
| [Consent allowing data authored by a practitioner](Consent-ex-consent-intermediate-authoredby.md) |
| [Consent allowing specific data](Consent-ex-consent-intermediate-data.md) |
| [Consent allowing data authored related to an encounter](Consent-ex-consent-intermediate-encounter.md) |
| [Consent allowing most sharing but NOT data authored by a practitioner](Consent-ex-consent-intermediate-not-authoredby.md) |
| [Consent allowing most sharing but NOT specific data](Consent-ex-consent-intermediate-not-data.md) |
| [Consent allowing most sharing but NOT data related to an encounter](Consent-ex-consent-intermediate-not-encounter.md) |
| [Consent allowing most sharing but NOT data authored within a timeframe](Consent-ex-consent-intermediate-not-timeframe.md) |
| [Consent allowing data access for a given intermediate purpose](Consent-ex-consent-intermediate-purpose.md) |
| [Consent allowing data authored within a timeframe](Consent-ex-consent-intermediate-timeframe.md) |
| [Consent forbid data access except for Break-Glass](Consent-ex-dissent-intermediate-break-glass.md) |

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-IHE.PCF.consentIntermediate-testing.md) | [top](#top) |  [next>](StructureDefinition-IHE.PCF.consentIntermediate.profile.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

