# IHE PCF Explicit Basic Consent - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE PCF Explicit Basic Consent**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-IHE.PCF.consentBasic-definitions.md) 
*  [Mappings](StructureDefinition-IHE.PCF.consentBasic-mappings.md) 
*  [Examples](StructureDefinition-IHE.PCF.consentBasic-examples.md) 
*  [XML](StructureDefinition-IHE.PCF.consentBasic.profile.xml.md) 
*  [JSON](StructureDefinition-IHE.PCF.consentBasic.profile.json.md) 

## Resource Profile: IHE PCF Explicit Basic Consent 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/StructureDefinition/IHE.PCF.consentBasic | *Version*:1.1.1-current |
| Active as of 2025-10-07 | *Computable Name*:BasicConsent |

 
Explicit Basic Consent 
* status 1..1 - would indicate active
* scope 1..1 - #patient-privacy
* category 1..1 - would indicate patient consent, specifically a delegation of authority
* identifier 0..1 - no defined use in PCF. This could carry business identifiers assigned to the consent instance
* patient 1..1 - would indicate the Patient resource reference for the given patient
* dateTime 1..1 - would indicate when the privacy policy was presented
* performer 1.. - would indicate the Patient resource if the patient was presented, a RelatedPerson for parent or guardian
* organization 1.. - would indicate the Organization that presented the privacy policy, and that is going to enforce that privacy policy
* source 1..1 - would point at the specific signed consent by the patient
* policy.uri 1..1 - would indicate the privacy policy that was presented. Usually, the url to the version-specific policy
* provision.type 1..1 - permit indicates agreement with the policy, deny would indicate rejection.
* provision.actor 0..* - would indicate those being granted permit / denied access, if empty then all in the community
* provision.actor.role - fixed value IRCP to indicate information recipient.
* provision.purpose - would indicate some set of authorized purposeOfUse
* provision.period MS - would indicate a sunset for the consent if applicable, empty means no expiration
* provision.provisions are allowed
 
Not defined in PCF, but allowed 
* policy.authority - **not used** in PCF
* policyRule - **not used** in PCF
 
Not allowed in PCF 
* provision.provision.provisions - **NOT allowed**, no clear use-case need and would add complexity
* verification - **not used** in PCF, unclear the use-case need
* provision.action - **not used** in PCF. The purpose is sufficient.
* provision.class - **not used** in PCF, unclear the use-case need
* provision.code - **not used** in PCF, unclear the use-case need
 
Specifics of Basic: 
* provision.purpose - would indicate some set of authorized purposeOfUse only Treatment, Payment, or Operations, see Intermediate
* provision.securityLabel is not allowed, see Intermediate
* provision.dataPeriod is not allowed, see Intermediate
* provision.data is nto allowed, see Intermediate
* provision.provision are NOT allowed, see Intermediate
 

**Usages:**

* Examples for this Profile: [Consent/ex-consent-basic-ink](Consent-ex-consent-basic-ink.md), [Consent/ex-consent-basic-reject](Consent-ex-consent-basic-reject.md), [Consent/ex-consent-basic-research](Consent-ex-consent-basic-research.md), [Consent/ex-consent-basic-treat-infant](Consent-ex-consent-basic-treat-infant.md)...Show 2 more,[Consent/ex-consent-basic-treat](Consent-ex-consent-basic-treat.md)and[Consent/ex-consent-expired-treat](Consent-ex-consent-expired-treat.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.iti.pcf|current/StructureDefinition/IHE.PCF.consentBasic)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 7 elements(1 nested mandatory element)
 Must-Support: 4 elements
 Prohibited: 9 elements

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 7 elements(1 nested mandatory element)
 Must-Support: 4 elements
 Prohibited: 9 elements

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCF.consentBasic.csv), [Excel](StructureDefinition-IHE.PCF.consentBasic.xlsx), [Schematron](StructureDefinition-IHE.PCF.consentBasic.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](Patient-ex-patient.ttl.md) | [top](#top) |  [next>](StructureDefinition-IHE.PCF.consentBasic-definitions.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

