# IHE PCF Explicit Basic Consent - Examples - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE PCF Explicit Basic Consent**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Content](StructureDefinition-IHE.PCF.consentBasic.md) 
*  [Detailed Descriptions](StructureDefinition-IHE.PCF.consentBasic-definitions.md) 
*  [Mappings](StructureDefinition-IHE.PCF.consentBasic-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-IHE.PCF.consentBasic.profile.xml.md) 
*  [JSON](StructureDefinition-IHE.PCF.consentBasic.profile.json.md) 

## Resource Profile: BasicConsent - Examples

| |
| :--- |
| Active as of 2025-10-07 |

Examples for the IHE.PCF.consentBasic Profile.

| |
| :--- |
| [Consent for treatment example with ink signature](Consent-ex-consent-basic-ink.md) |
| [Dissent for treatment example](Consent-ex-consent-basic-reject.md) |
| [Consent for any Healthcare Research example](Consent-ex-consent-basic-research.md) |
| [Consent for access for treatment example given by mother to infants data](Consent-ex-consent-basic-treat-infant.md) |
| [Consent for purpose of treatment example](Consent-ex-consent-basic-treat.md) |
| [Consent for treatment example with expiration](Consent-ex-consent-expired-treat.md) |

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-IHE.PCF.consentBasic-testing.md) | [top](#top) |  [next>](StructureDefinition-IHE.PCF.consentBasic.profile.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

