# IHE PCF Explicit Advanced Consent - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE PCF Explicit Advanced Consent**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-IHE.PCF.consentAdvanced-definitions.md) 
*  [Mappings](StructureDefinition-IHE.PCF.consentAdvanced-mappings.md) 
*  [Examples](StructureDefinition-IHE.PCF.consentAdvanced-examples.md) 
*  [XML](StructureDefinition-IHE.PCF.consentAdvanced.profile.xml.md) 
*  [JSON](StructureDefinition-IHE.PCF.consentAdvanced.profile.json.md) 

## Resource Profile: IHE PCF Explicit Advanced Consent 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/StructureDefinition/IHE.PCF.consentAdvanced | *Version*:1.1.1-current |
| Active as of 2025-10-07 | *Computable Name*:AdvancedConsent |

 
Explicit Advanced Consent 
* all elements allowed by Basic and Intermediate are allowed here, plus the following
* `securityLabel` indicates sensitivity or confidentiality tags on data 
* Only codes from [Avanced Security Tag ValueSet](ValueSet-AdvancedSecurityTagVS.md)
 
 

**Usages:**

* Examples for this Profile: [Consent/ex-consent-advanced-normal-break-glass-restricted](Consent-ex-consent-advanced-normal-break-glass-restricted.md), [Consent/ex-consent-advanced-normal-focused-psy-or-sdv](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md), [Consent/ex-consent-advanced-normal-focused-psy](Consent-ex-consent-advanced-normal-focused-psy.md), [Consent/ex-consent-advanced-normal-focused-restricted](Consent-ex-consent-advanced-normal-focused-restricted.md)...Show 3 more,[Consent/ex-consent-advanced-normal-not-restricted](Consent-ex-consent-advanced-normal-not-restricted.md),[Consent/ex-consent-advanced-normal-restricted](Consent-ex-consent-advanced-normal-restricted.md)and[Consent/ex-consent-advanced-normal](Consent-ex-consent-advanced-normal.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.iti.pcf|current/StructureDefinition/IHE.PCF.consentAdvanced)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 7 elements(1 nested mandatory element)
 Must-Support: 5 elements
 Prohibited: 5 elements

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Consent](http://hl7.org/fhir/R4/consent.html) 

**Summary**

Mandatory: 7 elements(1 nested mandatory element)
 Must-Support: 5 elements
 Prohibited: 5 elements

 

Other representations of profile: [CSV](StructureDefinition-IHE.PCF.consentAdvanced.csv), [Excel](StructureDefinition-IHE.PCF.consentAdvanced.xlsx), [Schematron](StructureDefinition-IHE.PCF.consentAdvanced.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](Consent-ex-consent-advanced-normal.ttl.md) | [top](#top) |  [next>](StructureDefinition-IHE.PCF.consentAdvanced-definitions.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

