# IHE PCF Explicit Advanced Consent - Examples - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE PCF Explicit Advanced Consent**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Content](StructureDefinition-IHE.PCF.consentAdvanced.md) 
*  [Detailed Descriptions](StructureDefinition-IHE.PCF.consentAdvanced-definitions.md) 
*  [Mappings](StructureDefinition-IHE.PCF.consentAdvanced-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-IHE.PCF.consentAdvanced.profile.xml.md) 
*  [JSON](StructureDefinition-IHE.PCF.consentAdvanced.profile.json.md) 

## Resource Profile: AdvancedConsent - Examples

| |
| :--- |
| Active as of 2025-10-07 |

Examples for the IHE.PCF.consentAdvanced Profile.

| |
| :--- |
| [Consent allowing NORMAL and break-glass access to RESTRICTED data](Consent-ex-consent-advanced-normal-break-glass-restricted.md) |
| [Consent allowing NORMAL and focused access to Mental Health or Sexual Health data](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.md) |
| [Consent allowing NORMAL and focused Mental Health data access](Consent-ex-consent-advanced-normal-focused-psy.md) |
| [Consent allowing NORMAL and focused RESTRICTED data access](Consent-ex-consent-advanced-normal-focused-restricted.md) |
| [Consent allowing NORMAL but not RESTRICTED data access](Consent-ex-consent-advanced-normal-not-restricted.md) |
| [Consent allowing NORMAL and RESTRICTED data access](Consent-ex-consent-advanced-normal-restricted.md) |
| [Consent allowing NORMAL data access](Consent-ex-consent-advanced-normal.md) |

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-IHE.PCF.consentAdvanced-testing.md) | [top](#top) |  [next>](StructureDefinition-IHE.PCF.consentAdvanced.profile.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

