# Example of an MHV blood sugar R4 observation - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example of an MHV blood sugar R4 observation**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Observation-ex-bloodSugar.xml.md) 
*  [JSON](Observation-ex-bloodSugar.json.md) 

## Example Observation: Example of an MHV blood sugar R4 observation

Security Labels: test health data (Details: ActReason code HTEST = 'test health data'), normal (Details: Confidentiality code N = 'normal')

**status**: Final

**category**: Laboratory

**code**: Glucose [Mass/volume] in Blood

**subject**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**encounter**: [Encounter: status = finished; class = home health (ActCode#HH)](Encounter-ex-encounter.md)

**effective**: 2020-12-04 23:50:50-0500

**performer**: [Practitioner: telecom = Author@example.com](Practitioner-ex-author.md)

**value**: 99 mg/dL(Details: UCUM codemg/dL = 'mg/dL')

**note**: 

> 

a bit low, no indicated method, no indicated eating


| | | |
| :--- | :--- | :--- |
|  [<prev](Observation-ex-weight.ttl.md) | [top](#top) |  [next>](Observation-ex-bloodSugar.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

