# 2:3.108 Access Consent [ITI-108] - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* **2:3.108 Access Consent [ITI-108]**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

## 2:3.108 Access Consent [ITI-108]

* [2:3.108.1 Scope](#231081-scope)
* [2:3.108.2 Actors Roles](#231082-actors-roles)
* [2:3.108.3 Referenced Standards](#231083-referenced-standards)
* [2:3.108.4 Messages / Interactions](#231084-messages--interactions)
* [2:3.108.5 Security Considerations](#231085-security-considerations)

This section corresponds to transaction [ITI-108] of the IHE Technical Framework. Transaction [ITI-108] is used by the Consent Recorder, Consent Authorization Server, and Consent Registry Actors.

### 2:3.108.1 Scope

The Access Consent transaction is used to find Consent Resources that satisfy a set of parameters, retrieve an instance of a Consent Resource, Create a new Consent Resource, or to Update an existing Consent Resource. This transaction is made up of discrete http RESTful interactions (aka messages): Create, Read, Update, Delete, and Search. The Consent resource is intended to be compliant with the PCF defined [Actor Options](volume-1.md#actor-options) and PCF defined [Consent Resource constraints](content.md). The ITI-108 transaction does not require compliance to the to these profiles of the [Consent Resource constraints](content.md), although the Consent Registry Actor could be configured to assure compliance.

The Access Consent transaction is focused on fundamental RESTful interactions. The [Consent Recorder](CapabilityStatement-IHE.PCF.consentRecorder.md) Actor has a more [nuanced interaction between the patient and the organization](ch-P.md#privacy-preferences), and possibly with others like a delegate of the patient with authorization to act on behalf of the patient. This nuanced interaction may also consider Privacy Preferences, current Consent rules, and organization rules. The PCF does not impose any specific behaviour at the [Consent Recorder](CapabilityStatement-IHE.PCF.consentRecorder.md) actor. There is an impact on the use of the Access Consent transaction when there is an existing Consent that is being changed. This change must follow some workflow imposed by the organization capturing the consent. This change will utalize the Access Consent transaction, specifically the Create, Update, and/or Delete interaction. There are a few patterns that the organization may chose to follow:

1. Revise the existing FHIR Consent instance. That is to use the Update interaction to change the Consent. In this environment one must be able to understand the previous Consent rules in order to understand previous enforcements and the AuditEvent logged. The[Consent Registry](CapabilityStatement-IHE.PCF.consentRegistry.md)may be using FHIR version support, thus all Updates create a history of the past.
1. Add a new FHIR Consent, and update the old FHIR Consent to indicate it is inactive. The history is clear, and this model does not require the[Consent Registry](CapabilityStatement-IHE.PCF.consentRegistry.md)to have implemented FHIR version support, although it is still useful.
1. Add a new FHIR Consent, and delete the old FHIR Consent. The implementation of[FHIR delete](http://hl7.org/fhir/R4/http.html#delete)is often implemented logically, thus the previous Consent Resource instance is available administratively. The use of delete should only be used with careful consideration of longterm lifecycle management and accountability.

### 2:3.108.2 Actors Roles

**Table 2:3.108.2-1: Actor Roles**

| | |
| :--- | :--- |
| [Consent Recorder](volume-1.md#consentRecorder) | Searches and Retrieves existing Consents, and Creates or Updates existing Consents |
| [Consent Registry](volume-1.md#consentRegistry) | Maintains Consent Resources, and responds to Search and Retrieve requests |
| [Consent Authorization Server](volume-1.md#consentAuthorizationServer) | Searches and Retrieves existing Consents so that authorization decisions can be made |

#### 2:3.108.2.1 CapabilityStatement Resource

Server implementing this transaction shall provide a CapabilityStatement Resource as described in ITI TF-2x: Appendix Z.3 indicating the transaction has been implemented.

* Requirements CapabilityStatement for [Consent Recorder](CapabilityStatement-IHE.PCF.consentRecorder.md)
* Requirements CapabilityStatement for [Consent Registry](CapabilityStatement-IHE.PCF.consentRegistry.md)
* Requirements CapabilityStatement for [Consent Authorization Server](CapabilityStatement-IHE.PCF.consentAuthorizationServer.md)

### 2:3.108.3 Referenced Standards

**FHIR-R4** [HL7 FHIR Release 4.0](http://hl7.org/fhir/R4/)

### 2:3.108.4 Messages / Interactions

**Figure 2:3.108.4-1: Access Consent Interactions**


#### 2:3.108.4.1 Search Request

The Consent Recorder or Consent Authorization Server uses this request to find available Consent Resources given some search parameters.

##### 2:3.108.4.1.1 Trigger Events

When the Consent Recorder or Consent Authorization Server needs to discover available Consent Resources given some search parameters.

##### 2:3.108.4.1.2 Message Semantics

The Consent Recorder or Consent Authorization Server executes an HTTP search against the Consent Registry Consent URL. The search target follows the FHIR HTTP specification, addressing the Consent Resource [http://hl7.org/fhir/R4/http.html](http://hl7.org/fhir/R4/http.html):

```
[base]/Consent?<query>

```

This URL is configurable by the Consent Registry and is subject to the following constraints:

The `<query>` represents a series of encoded name-value pairs representing the filter for the query, as specified in Section [Query Search Parameters](#231084121-query-search-parameters), as well as control parameters to modify the behavior of the Consent Registry such as response format, or pagination.

The Consent Recorder or Consent Authorization Server Actor may use GET or POST based searches. The Consent Registry shall support both GET and POST based searches [http://hl7.org/fhir/R4/http.html#search](http://hl7.org/fhir/R4/http.html#search).

###### 2:3.108.4.1.2.1 Query Search Parameters

The Consent Recorder or Consent Authorization Server may supply, and the Consent Registry shall be capable of processing, all query parameters listed below. All query parameter values shall be appropriately encoded per RFC3986 “percent” encoding rules. Note that percent encoding does restrict the character set to a subset of ASCII characters which is used for encoding all other characters used in the URL.

The Consent Recorder or Consent Authorization Server shall include search parameter `patient` or `patient.identifier`, and `status`. The Consent Registry must implement the parameters described below. The Consent Registry may choose to support additional query parameters beyond the subset listed below. Any additional query parameters supported shall be supported according to the core FHIR specification. Such additional parameters are considered out of scope for this transaction. Any additional parameters not supported should be ignored. See [http://hl7.org/fhir/R4/search.html#errors](http://hl7.org/fhir/R4/search.html#errors).

**actor**: This parameter is of type Reference. This parameter would be used to look for Consent Resources that explicitly identify an actor for which there is a provision. Note that the absence of an explicit actor does not mean an absence of applicability of Consent resources.

**patient**: This parameter is of type Reference(Patient). The Consent Recorder or Consent Authorization Server may get this reference using the [PDQm](https://profiles.ihe.net/ITI/TF/Volume1/ch-38.html) or [PIXm](https://profiles.ihe.net/ITI/TF/Volume1/ch-41.html) Profile. When the patient parameter is used, the Patient reference would need to be accessible to both the Consent Recorder or Consent Authorization Server and the Consent Registry.

**patient.identifier**: This parameter, of type token, specifies an identifier associated with the patient to which the Consent Resource is assigned. See [ITI TF-2x: Appendix Z.2](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.2-query-parameters) for additional constraints on the use of the token search parameter type. This use of **patient.identifier** follows the [FHIR Chaining Parameters](http://hl7.org/fhir/R4/search.html#chaining) search methodology.

**status**: This parameter, of type token, specifies the status of the Consent Resource. The use of this parameter can eliminate Consent resources that are in states that are not of interest, such as draft or inactive.

###### 2:3.108.4.1.2.2 Populating Expected Response Format

The FHIR standard provides encodings for responses as either XML or JSON. The Consent Registry shall support both message encodings, whilst the Consent Recorder or Consent Authorization Server shall support one and may support both.

See [ITI TF-2x: Appendix Z.6](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.6-populating-the-expected-response-format) for details.

##### 2:3.108.4.1.3 Expected Actions

The Consent Registry shall process the query to discover the Consent entries that match the search parameters given.

#### 2:3.108.4.2 Search Response

The Consent Registry returns a HTTP Status code appropriate to the processing as well as a Bundle of the matching Consent Resources.

##### 2:3.108.4.2.1 Trigger Events

The Consent Registry has processed has processed the search interaction.

##### 2:3.108.4.2.2 Message Semantics

Based on the query results, the Consent Registry will either return an error or success. Guidance on handling Access Denied related to use of 200, 403 and 404 can be found in [ITI TF-2x: Appendix Z.7](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.8-mobile-security-considerations).

When the Consent Registry needs to report an error, it shall use HTTP error response codes and should include a FHIR OperationOutcome with more details on the failure. See FHIR [http://hl7.org/fhir/R4/http.html](http://hl7.org/fhir/R4/http.html) and [http://hl7.org/fhir/R4/operationoutcome.html](http://hl7.org/fhir/R4/operationoutcome.html).

If the search interaction is processed successfully, whether or not any Consent Resources are found, the HTTP status code shall be 200. The search response message shall be a Bundle Resource containing zero or more Consent Resources. If the Consent Registry is sending warnings, the Bundle Resource shall also contain an OperationOutcome Resource that contains those warnings.

The response shall adhere to the FHIR Bundle constraints specified in [ITI TF-2x: Appendix Z.1](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.1-resource-bundles).

###### 2:3.108.4.2.2.1 Consent Resource Contents

The Consent Resources returned shall be compliant with the FHIR specification [http://hl7.org/fhir/R4/consent.html](http://hl7.org/fhir/R4/consent.html).

The Consent Resources returned should be compliant with the IHE restrictions on the Consent Resource.

##### 2:3.108.4.2.3 Expected Actions

The Consent Recorder or Consent Authorization Server shall process the results according to application-defined rules. The Consent Recorder or Consent Authorization Server should be robust as the response may contain Consent Resources that match the query parameters but are not compliant with the IHE Consent constraints defined here.

#### 2:3.108.4.3 Create Request

The Consent Recorder has a need to create a new Consent Resource.

##### 2:3.108.4.3.1 Trigger Events

A new Consent Resource needs to be recorded.

##### 2:3.108.4.3.2 Message Semantics

The [FHIR create interaction](http://hl7.org/fhir/R4/http.html#create) is used. See [http://hl7.org/fhir/R4/http.html#create](http://hl7.org/fhir/R4/http.html#create).

[Update as Create](http://hl7.org/fhir/R4/http.html#upsert) is not required but may be supported by the actors beyond the scope of this transaction.

##### 2:3.108.4.3.3 Expected Actions

The Consent Registry shall handle the create request according to policy. See the discussion in the [FHIR create interaction](http://hl7.org/fhir/R4/http.html#create).

#### 2:3.108.4.4 Create Response

The Consent Recorder has received an Create Request and needs to return a response.

##### 2:3.108.4.4.1 Trigger Events

The Consent Registry has processed the [FHIR create interaction](http://hl7.org/fhir/R4/http.html#create).

##### 2:3.108.4.4.2 Message Semantics

See the [FHIR create interaction](http://hl7.org/fhir/R4/http.html#create). The success or failure of the create interaction is indicated by the http response code (e.g., 400, 200, etc.).

##### 2:3.108.4.4.3 Expected Actions

There is no defined expected actions to be taken by the Consent Recorder, however user interface and workflow may be affected by the response code.

#### 2:3.108.4.5 Read Request

The Consent Recorder or Consent Authorization Server have a Consent `id` and need to retrieve the current Consent resource instance. The `id` may have been discovered via some undefined method. For example an authorization token request may be referring to a Consent by `id`. Note that search can also be used given an `id`, but will result in a Bundle, whereas the Read Request returns only the Consent resource.

##### 2:3.108.4.5.1 Trigger Events

A specific Consent is needed and the `id` is known.

##### 2:3.108.4.5.2 Message Semantics

The [FHIR read interaction](http://hl7.org/fhir/R4/http.html#read) or [FHIR vread interaction](http://hl7.org/fhir/R4/http.html#vread) are used. See [http://hl7.org/fhir/R4/http.html#vread](http://hl7.org/fhir/R4/http.html#vread) and [http://hl7.org/fhir/R4/http.html#vread](http://hl7.org/fhir/R4/http.html#vread). The Consent Registry shall support both interactions.

##### 2:3.108.4.5.3 Expected Actions

The Consent Registry shall handle the read or vread request according to policy. See the discussion in the [FHIR read interaction](http://hl7.org/fhir/R4/http.html#read) and [http://hl7.org/fhir/R4/http.html#vread](http://hl7.org/fhir/R4/http.html#vread).

#### 2:3.108.4.6 Read Response

The Consent Recorder has received a read or vread request and needs to return a response.

##### 2:3.108.4.6.1 Trigger Events

The Consent Recorder has processed the [FHIR read interaction](http://hl7.org/fhir/R4/http.html#read) or [FHIR vread interaction](http://hl7.org/fhir/R4/http.html#vread).

##### 2:3.108.4.6.2 Message Semantics

See the [FHIR read interaction](http://hl7.org/fhir/R4/http.html#read) and [FHIR vread interaction](http://hl7.org/fhir/R4/http.html#vread). The success or failure of the read interaction is indicated by the http response code (e.g., 404, 200, etc.).

##### 2:3.108.4.6.3 Expected Actions

There is no defined expected actions to be taken, however user interface and workflow may be affected by the response code.

#### 2:3.108.4.7 Update Request

The Consent Recorder has a need to update an identified existing Consent Resource. This might be because the terms of a Consent has changed, or might be because a `Consent.status` needs to be updated, such as to mark a Consent as `inactive`.

##### 2:3.108.4.7.1 Trigger Events

The Consent Recorder has a need to update an identified existing Consent Resource.

##### 2:3.108.4.7.2 Message Semantics

The [FHIR update interaction](http://hl7.org/fhir/R4/http.html#update) is used. See [http://hl7.org/fhir/R4/http.html#update](http://hl7.org/fhir/R4/http.html#update).

[Update as Create](http://hl7.org/fhir/R4/http.html#upsert), [Conditional update](http://hl7.org/fhir/R4/http.html#cond-update), and [Patch](http://hl7.org/fhir/R4/http.html#patch) are not required but may be supported by the actors beyond the scope of this transaction.

##### 2:3.108.4.7.3 Expected Actions

The Consent Registry shall handle the update request according to policy. See the discussion in the [FHIR update interaction](http://hl7.org/fhir/R4/http.html#update).

#### 2:3.108.4.8 Update Response

The Consent Recorder has received an Update Request and needs to return a response.

##### 2:3.108.4.8.1 Trigger Events

The Consent Recorder has processed the [FHIR update interaction](http://hl7.org/fhir/R4/http.html#update).

##### 2:3.108.4.8.2 Message Semantics

See the [FHIR update interaction](http://hl7.org/fhir/R4/http.html#update). The success or failure of the update interaction is indicated by the http response code (e.g., 400, 200, etc.).

##### 2:3.108.4.8.3 Expected Actions

There is no defined expected actions to be taken by the Consent Recorder, however user interface and workflow may be affected by the response code.

#### 2:3.108.4.9 Delete Request

The Consent Recorder could use this interaction to delete a Consent Resource. Note that Delete may not be supported, and thus the use of Update to a `Consent.status` to `inactive` may be the more proper policy. Note that when a Consent Resource is [created in error](http://hl7.org/fhir/R4/lifecycle.html#error), the use of Update to a `Consent.status` of `entered-in-error` may be preferred.

##### 2:3.108.4.9.1 Trigger Events

The Consent Recorder has a need to delete an identified existing Consent Resource.

##### 2:3.108.4.9.2 Message Semantics

The [FHIR delete interaction](http://hl7.org/fhir/R4/http.html#delete) is used. See [http://hl7.org/fhir/R4/http.html#delete](http://hl7.org/fhir/R4/http.html#delete).

[Conditional Delete](http://hl7.org/fhir/R4/http.html#3.1.0.7.1) is not required but may be supported by the actors beyond the scope of this transaction.

##### 2:3.108.4.9.2 Expected Actions

The Consent Registry shall handle the delete request according to policy. See the discussion in the [FHIR delete interaction](http://hl7.org/fhir/R4/http.html#delete).

#### 2:3.108.4.10 Delete Response

The Consent Recorder has received a Delete Request and needs to return a response.

##### 2:3.108.4.10.1 Trigger Events

The Consent Recorder has processed the [FHIR delete interaction](http://hl7.org/fhir/R4/http.html#delete).

##### 2:3.108.4.10.2 Message Semantics

See the [FHIR delete interaction](http://hl7.org/fhir/R4/http.html#delete). The success or failure of the delete interaction is indicated by the http response code (e.g., 405, 200, etc.).

##### 2:3.108.4.10.3 Expected Actions

There is no defined expected actions to be taken by the Consent Recorder, however user interface and workflow may be affected by the response code.

### 2:3.108.5 Security Considerations

See [PCF Security Considerations](volume-1.md#security-considerations).

This transaction should not return information that the Consent Recorder or Consent Authorization Server is not authorized to access. Where authorization here is inclusive of system, app, and user according to local policy, patient consents, and security layering. However, the transaction may return Consent resources that have Reference elements that may not have access to. This is to say that the authorization need only be to the content returned in the Bundle. There may be references (URLs) for which the content is not authorized. This is considered proper as the client would need to retrieve the content pointed to by those references, and at that time the proper authorization decision would be made on that context and content. In this way it is possible for a client to get Consent resources that are pointing at data that the client is not authorized to retrieve. Thus, the URLs used must be carefully crafted so as to not expose sensitive data in the URL value.

#### 2:3.108.5.1 Security Audit Considerations

Recording audit logs is important for Security, Privacy, and data integrity assurance.

##### 2:3.108.5.1.1 Consent Recorder Audit

The Consent Recorder when grouped with ATNA Secure Node or Secure Application shall be able to record a [Patient specific REST event AuditEvent as defined](https://profiles.ihe.net/ITI/BALP/content.html#3573-restful-activities) in [IHE Basic Audit Log Patterns (BALP)](https://profiles.ihe.net/ITI/BALP/index.html).

##### 2:3.108.5.1.2 Consent Authorization Server Audit

The Consent Authorization Server when grouped with ATNA Secure Node or Secure Application shall be able to record a [Patient specific REST event AuditEvent as defined](https://profiles.ihe.net/ITI/BALP/content.html#3573-restful-activities) in [IHE Basic Audit Log Patterns (BALP)](https://profiles.ihe.net/ITI/BALP/index.html).

##### 2:3.108.5.1.2 Consent Registry Audit

The Consent Recorder when grouped with ATNA Secure Node or Secure Application shall be able to record a [Patient specific REST event AuditEvent as defined](https://profiles.ihe.net/ITI/BALP/content.html#3573-restful-activities) in [IHE Basic Audit Log Patterns (BALP)](https://profiles.ihe.net/ITI/BALP/index.html).

| | | |
| :--- | :--- | :--- |
|  [<prev](ch-P.md) | [top](#top) |  [next>](content.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

